<?php
	
	use \Psr\Http\Message\ServerRequestInterface as Request;
	use \Psr\Http\Message\ResponseInterface as Response;
	
	use \Vinteract\Client as Client;
	
	require("vendor/autoload.php");
	
	$config = new \Slim\Container([
		"settings" => [
			"displayErrorDetails" => true,
		],
	]);
	
	$app = new \Slim\App($config);
	
	/*
		Environment
	*/
	
	$whitelist = array(
		"127.0.0.1",
		"::1"
	);

	if(in_array($_SERVER["REMOTE_ADDR"], $whitelist)){
		define("ENVIRONMENT", "development");
	} else {
		define("ENVIRONMENT", "production");
	}
	
	/*
		Middleware
	*/
	
	$app->add(function ($req, $res, $next) {
	    $response = $next($req, $res);
	    return $response
			->withHeader('Access-Control-Allow-Origin', '*')
			->withHeader('Access-Control-Allow-Headers', 'X-Requested-With, Content-Type, Accept, Origin, Vinteract-Client-Id')
			->withHeader('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, PATCH, OPTIONS');
	});
	
	$app->add(function($request, $response, $next) {
		
		// Init client?
		
		$headers = $request->getHeader("Vinteract-Client-Id");
		
		if (count($headers)) {
			Vinteract\Client::init($headers[0]);
		} else {
			Vinteract\Client::init("EjNic");
		}
		
		// Return response.
		
		return $next($request, $response);
		
	});
	
	/*
		Base
	*/
	
	$app->post("/", function(Request $request, Response $response, array $args) {
		
		// Variables.
		
		$post = $request->getParsedBody();
		
		$settings = $post["settings"];
		
		// Update content features.
		
		if (array_key_exists("content", $settings)) {
			foreach($settings["content"] as $feature) {
				if (array_key_exists("permission_key", $feature)) {
					Client::local("settings_features")->where("key", $feature["permission_key"])->update(["value" => $feature["permission"]]);
				}
				if (array_key_exists("label_key", $feature)) {
					Client::local("settings_labels")->where("key", $feature["label_key"])->update(["value" => $feature["label"]]);
				}
			}
		}
		
		// Update informational features.
		
		if (array_key_exists("information", $settings)) {
			foreach($settings["information"] as $feature) {
				if (array_key_exists("permission_key", $feature)) {
					Client::local("settings_features")->where("key", $feature["permission_key"])->update(["value" => $feature["permission"]]);
				}
				if (array_key_exists("label_key", $feature)) {
					Client::local("settings_labels")->where("key", $feature["label_key"])->update(["value" => $feature["label"]]);
				}
			}
		}
		
		// Update kids corner.
		
		if (array_key_exists("kids", $settings)) {
			foreach($settings["kids"] as $feature) {
				if (array_key_exists("permission_key", $feature)) {
					Client::local("settings_features")->where("key", $feature["permission_key"])->update(["value" => $feature["permission"]]);
				}
				if (array_key_exists("label_key", $feature)) {
					Client::local("settings_labels")->where("key", $feature["label_key"])->update(["value" => $feature["label"]]);
				}
			}
		}
		
		// Update premium features.
		
		if (array_key_exists("premium", $settings)) {
			foreach($settings["premium"] as $feature) {
				if (array_key_exists("permission_key", $feature)) {
					Client::local("settings_features")->where("key", $feature["permission_key"])->update(["value" => $feature["permission"]]);
				}
				if (array_key_exists("label_key", $feature)) {
					Client::local("settings_labels")->where("key", $feature["label_key"])->update(["value" => $feature["label"]]);
				}
			}
		}

		// Update content filters.
		
		if (array_key_exists("filters", $settings)) {
			foreach($settings["filters"] as $feature) {
				if (array_key_exists("permission_key", $feature)) {
					Client::local("settings_features")->updateOrInsert([
						"key" => $feature["permission_key"]
					],[
						"value" => $feature["permission"]
					]);
				}
			}
		}
		
		// Update events.
		
		if (array_key_exists("events", $settings)) {
			
			Client::local("settings_features")->where("key", $settings["events"]["permission_key"])->update(["value" => $settings["events"]["permission"]]);
			Client::local("settings_features")->where("key", $settings["events"]["rsvp_permission_key"])->update(["value" => $settings["events"]["rsvp_permission"]]);
			
			Client::local("settings_labels")->where("key", $settings["events"]["label_key"])->update(["value" => $settings["events"]["label"]]);
			
			Client::local("settings_events")->update(["recipient_address" => implode(",", $settings["events"]["rsvp_recipients"])]);
			
		}
		
		// Update prayer requests.
		
		if (array_key_exists("prayer_requests", $settings)) {
			
			Client::local("settings_features")->where("key", $settings["prayer_requests"]["permission_key"])->update(["value" => $settings["prayer_requests"]["permission"]]);
			
			Client::local("settings_labels")->where("key", $settings["prayer_requests"]["label_key"])->update(["value" => $settings["prayer_requests"]["label"]]);
			Client::local("settings_labels")->where("key", "compose_prayer_request")->update(["value" => $settings["prayer_requests"]["compose_prayer_request"]]);
			Client::local("settings_labels")->where("key", "private_prayer_request_confirmation")->update(["value" => $settings["prayer_requests"]["private_prayer_request_confirmation"]]);
			Client::local("settings_labels")->where("key", "public_prayer_request_confirmation")->update(["value" => $settings["prayer_requests"]["public_prayer_request_confirmation"]]);
			
			Client::local("settings_prayer_requests")->update(["recipient_address" => implode(",", $settings["prayer_requests"]["recipients"])]);
			
		}
		
		// Update fan wall.
		
		if (array_key_exists("fan_wall", $settings)) {
			
			Client::local("settings_features")->where("key", $settings["fan_wall"]["permission_key"])->update(["value" => $settings["fan_wall"]["permission"]]);
			
			Client::local("settings_labels")->where("key", $settings["fan_wall"]["label_key"])->update(["value" => $settings["fan_wall"]["label"]]);
			Client::local("settings_labels")->where("key", "compose_fan_post")->update(["value" => $settings["fan_wall"]["compose_fan_post"]]);
			
			Client::local("settings_fan_wall")->update(["recipient_address" => implode(",", $settings["fan_wall"]["recipients"])]);
			
		}
		
		// Update devotionals.
		
		if (array_key_exists("devotionals", $settings)) {
			
			Client::local("settings_features")->where("key", $settings["devotionals"]["permission_key"])->update(["value" => $settings["devotionals"]["permission"]]);
			
			Client::local("settings_labels")->where("key", $settings["devotionals"]["label_key"])->update(["value" => $settings["devotionals"]["label"]]);
			
			Client::local("settings_devotionals")->update([
				"show_date_added" => $settings["devotionals"]["show_date_added"],
				"source" => $settings["devotionals"]["source"],
				"url" => $settings["devotionals"]["url"]
			]);
			
		}
		
		// Update giving.
		
		if (array_key_exists("giving", $settings)) {
			
			Client::local("settings_features")->where("key", $settings["giving"]["permission_key"])->update(["value" => $settings["giving"]["permission"]]);
			
			Client::local("settings_labels")->where("key", $settings["giving"]["label_key"])->update(["value" => $settings["giving"]["label"]]);
			
			Client::local("settings_giving")->update(["url" => $settings["giving"]["url"]]);
			
		}
		
		// Update blog.
		
		if (array_key_exists("blog", $settings)) {
			
			Client::local("settings_features")->where("key", $settings["blog"]["permission_key"])->update(["value" => $settings["blog"]["permission"]]);
			
			Client::local("settings_labels")->where("key", $settings["blog"]["label_key"])->update(["value" => $settings["blog"]["label"]]);
			
			Client::local("settings_blog")->update(["url" => $settings["blog"]["url"]]);
			
		}
		
		// Update shop.
		
		if (array_key_exists("shop", $settings)) {
			
			Client::local("settings_features")->where("key", $settings["shop"]["permission_key"])->update(["value" => $settings["shop"]["permission"]]);
			
			Client::local("settings_labels")->where("key", $settings["shop"]["label_key"])->update(["value" => $settings["shop"]["label"]]);
			
			Client::local("settings_shop")->update(["url" => $settings["shop"]["url"]]);
			
		}
		
		// Update contact details.
		
		if (array_key_exists("contact", $settings)) {
			foreach($settings["contact"] as $key => $value) {
				Client::local("settings_home_other")->updateOrInsert([
					"key" => $key
				],[
					"value" => $value
				]);
			}
		}
		
		// Update social media.
		
		if (array_key_exists("social_media", $settings)) {
			foreach($settings["social_media"] as $key => $value) {
				Client::local("settings_social_media")->updateOrInsert([
					"key" => $key
				],[
					"value" => $value
				]);
			}
		}
		
		// Response.
		
		return $response->withJson((new \Vinteract\API\Response([
			"code" => 200,
			"contents" => [
				"settings" => $request->getParsedBody(),
			],
		]))->getResponseObject());
		
	});
	
	/*
		Init
	*/
	
	$app->get("/init", function(Request $request, Response $response, array $args) {
		
		// Variables.
		
		$settings = [];
		
		// General settings.
		
		$permissions = array_column(Client::local("settings_features")->get()->toArray(), "value", "key");
		
		$labels = array_column(Client::local("settings_labels")->get()->toArray(), "value", "key");
		
		$settings["permissions"] = $permissions;
		
		$settings["labels"] = $labels;
		
		$settings["social_media"] = array_column(Client::local("settings_social_media")->get()->toArray(), "value", "key");
		
		$settings["contact"] = array_column(Client::local("settings_home_other")->get()->toArray(), "value", "key");
		
		// General features.
		
		$settings["content"]["home"] = [
			"permission" => $permissions["content_home"],
			"permission_key" => "content_home",
			"permission_editable" => false,
			"label" => $labels["home"],
			"label_original" => "Home Screen",
			"label_key" => "home",
			"label_editable" => true,
		];
		
		$settings["content"]["news"] = [
			"permission" => $permissions["content_news"],
			"permission_key" => "content_news",
			"permission_editable" => true,
			"label" => $labels["news"],
			"label_original" => "News",
			"label_key" => "news",
			"label_editable" => true,
		];
		
		$settings["content"]["newsletters"] = [
			"permission" => $permissions["content_newsletters"],
			"permission_key" => "content_newsletters",
			"permission_editable" => true,
			"label" => $labels["newsletters"],
			"label_original" => "Newsletters",
			"label_key" => "newsletters",
			"label_editable" => true,
		];
		
		$settings["content"]["gallery"] = [
			"permission" => $permissions["content_gallery"],
			"permission_key" => "content_gallery",
			"permission_editable" => true,
			"label" => $labels["gallery"],
			"label_original" => "Photo Gallery",
			"label_key" => "gallery",
			"label_editable" => true,
		];
		
		// Church features.
		
		if (Client::getType() === "churches") {
			
			// Standard features.
			
			$settings["content"]["verses"] = [
				"permission" => $permissions["content_verses"],
				"permission_key" => "content_verses",
				"permission_editable" => true,
				"label" => $labels["verses"],
				"label_original" => "Daily Verse",
				"label_key" => "verses",
				"label_editable" => true,
			];
			
			$settings["content"]["sermons"] = [
				"permission" => $permissions["content_sermons"],
				"permission_key" => "content_sermons",
				"permission_editable" => true,
				"label" => $labels["sermons"],
				"label_original" => "Sermons",
				"label_key" => "sermons",
				"label_editable" => true,
			];
			
			$settings["kids"]["kids"] = [
				"permission" => $permissions["content_kids"],
				"permission_key" => "content_kids",
				"permission_editable" => true,
				"label" => $labels["kids"],
				"label_original" => "Kids Corner",
				"label_key" => "kids",
				"label_editable" => true,
			];
			
			$settings["kids"]["kids_news"] = [
				"permission" => $permissions["content_kids_news"],
				"permission_key" => "content_kids_news",
				"permission_editable" => true,
				"label" => $labels["kids_news"],
				"label_original" => "Kids News",
				"label_key" => "kids_news",
				"label_editable" => true,
			];
			
			$settings["kids"]["kids_verses"] = [
				"permission" => $permissions["content_kids_verses"],
				"permission_key" => "content_kids_verses",
				"permission_editable" => true,
				"label" => $labels["kids_verses"],
				"label_original" => "Kids Verses",
				"label_key" => "kids_verses",
				"label_editable" => true,
			];
			
			$settings["kids"]["kids_sermons"] = [
				"permission" => $permissions["content_kids_sermons"],
				"permission_key" => "content_kids_sermons",
				"permission_editable" => true,
				"label" => $labels["kids_sermons"],
				"label_original" => "Kids Sermons",
				"label_key" => "kids_sermons",
				"label_editable" => true,
			];
			
			$settings["kids"]["kids_devotionals"] = [
				"permission" => $permissions["content_kids_devotionals"],
				"permission_key" => "content_kids_devotionals",
				"permission_editable" => true,
				"label" => $labels["kids_devotionals"],
				"label_original" => "Kids Devotionals",
				"label_key" => "kids_devotionals",
				"label_editable" => true,
			];
			
			$settings["kids"]["kids_events"] = [
				"permission" => $permissions["content_kids_events"],
				"permission_key" => "content_kids_events",
				"permission_editable" => true,
				"label" => $labels["kids_events"],
				"label_original" => "Kids Events",
				"label_key" => "kids_events",
				"label_editable" => true,
			];
			
			$settings["kids"]["kids_newsletters"] = [
				"permission" => $permissions["content_kids_newsletters"],
				"permission_key" => "content_kids_newsletters",
				"permission_editable" => true,
				"label" => $labels["kids_newsletters"],
				"label_original" => "Kids Newsletters",
				"label_key" => "kids_newsletters",
				"label_editable" => true,
			];
			
			$settings["information"]["about"] = [
				"permission" => $permissions["us_about"],
				"permission_key" => "us_about",
				"permission_editable" => true,
				"label" => $labels["about"],
				"label_original" => "About Us",
				"label_key" => "about",
				"label_editable" => true,
			];
			
			$settings["information"]["ministries"] = [
				"permission" => $permissions["us_ministries"],
				"permission_key" => "us_ministries",
				"permission_editable" => true,
				"label" => $labels["ministries"],
				"label_original" => "Ministries",
				"label_key" => "ministries",
				"label_editable" => true,
			];
			
			$settings["information"]["team"] = [
				"permission" => $permissions["us_team"],
				"permission_key" => "us_team",
				"permission_editable" => true,
				"label" => $labels["team"],
				"label_original" => "Team",
				"label_key" => "team",
				"label_editable" => true,
			];
			
			$settings["information"]["church_locations"] = [
				"permission" => $permissions["us_church_locations"],
				"permission_key" => "us_church_locations",
				"permission_editable" => true,
				"label" => $labels["locations1"],
				"label_original" => "Church Locations",
				// Fixed: LEG-192 07-12-2021 Some of the custom label does not reflect in the App and Website
				"label_key" => "locations1",
				"label_editable" => true,
			];
			
			$settings["information"]["enquiries"] = [
				"permission" => $permissions["us_enquiries"],
				"permission_key" => "us_enquiries",
				"permission_editable" => true,
				"label" => $labels["enquiries"],
				"label_original" => "Enquiries",
				"label_key" => "enquiries",
				"label_editable" => true,
			];
			
			// Events.
			
			$settings_events = Client::local("settings_events")->select("recipient_address")->first();
			
			if (strlen($settings_events->recipient_address)) {
				$rsvp_recipients = explode(",", $settings_events->recipient_address);
			} else {
				$rsvp_recipients = [];
			}
			
			$settings["events"] = [
				
				"permission" => $permissions["content_events"],
				"permission_key" => "content_events",
				"permission_editable" => true,
				
				"label" => $labels["events"],
				"label_original" => "Events",
				"label_key" => "events",
				"label_editable" => true,
				
				"rsvp_recipients" => $rsvp_recipients,
				"rsvp_permission" => $permissions["content_rsvp"],
				"rsvp_permission_key" => "content_rsvp",
				"rsvp_label" => "RSVP",
				
			];
			
			// Prayer requests.
			
			$settings_prayer_requests = Client::local("settings_prayer_requests")->select("recipient_address")->first();
			
			if (strlen($settings_prayer_requests->recipient_address)) {
				$prayer_request_recipients = explode(",", $settings_prayer_requests->recipient_address);
			} else {
				$prayer_request_recipients = [];
			}
			
			$settings["prayer_requests"] = [
				
				"permission" => $permissions["content_prayer_requests"],
				"permission_key" => "content_prayer_requests",
				"permission_editable" => true,
				"label" => $labels["prayer_requests"],
				"label_original" => "Prayer Requests",
				"label_key" => "prayer_requests",
				"label_editable" => true,
				
				"recipients" => $prayer_request_recipients,
				
				"compose_prayer_request" => $labels["compose_prayer_request"],
				"public_prayer_request_confirmation" => $labels["public_prayer_request_confirmation"],
				"private_prayer_request_confirmation" => $labels["private_prayer_request_confirmation"],
				
			];
			
			// Devotionals.
			
			$settings_devotionals = Client::local("settings_devotionals")->first();
			
			$settings["devotionals"] = [
				
				"permission" => $permissions["content_devotionals"],
				"permission_key" => "content_devotionals",
				"permission_editable" => true,
				"label" => $labels["devotionals"],
				"label_original" => "Devotionals",
				"label_key" => "devotionals",
				"label_editable" => true,
				
				"source" => $settings_devotionals->source,
				"url" => $settings_devotionals->url,
				"show_date_added" => $settings_devotionals->show_date_added,
				
			];
			
			// Giving.
			
			$settings["giving"] = [
				
				"permission" => $permissions["us_giving"],
				"permission_key" => "us_giving",
				"permission_editable" => true,
				"label" => $labels["giving"],
				"label_original" => "Giving",
				"label_key" => "giving",
				"label_editable" => true,
				
				"url" => Client::local("settings_giving")->select("url")->value("url"),
				
			];
			
			// Blog.
			
			$settings["blog"] = [
				
				"permission" => $permissions["us_blog"],
				"permission_key" => "us_blog",
				"permission_editable" => true,
				
				"label" => $labels["blog"],
				"label_original" => "Blog",
				"label_key" => "blog",
				"label_editable" => true,
				
				"url" => Client::local("settings_blog")->select("url")->value("url"),
				
			];
			
		}
		
		// Business features.	
		
		if (Client::getType() === "businesses") {
			
			// Content features.
			
			$settings["content"]["advice"] = [
				"permission" => $permissions["content_advice"],
				"permission_key" => "content_advice",
				"permission_editable" => true,
				"label" => $labels["advice"],
				"label_original" => "Business Tips & Advice	",
				"label_key" => "advice",
				"label_editable" => true,
			];
			
			$settings["content"]["promotional_content"] = [
				"permission" => $permissions["content_promotional_content"],
				"permission_key" => "content_promotional_content",
				"permission_editable" => true,
				"label" => $labels["promotional_content"],
				"label_original" => "Promotional Content",
				"label_key" => "promotional_content",
				"label_editable" => true,
			];
			
			$settings["content"]["offers"] = [
				"permission" => $permissions["content_offers"],
				"permission_key" => "content_offers",
				"permission_editable" => true,
				"label" => $labels["offers"],
				"label_original" => "Offers",
				"label_key" => "offers",
				"label_editable" => true,
			];
			
			$settings["content"]["programs"] = [
				"permission" => $permissions["content_asa_programs"],
				"permission_key" => "content_asa_programs",
				"permission_editable" => true,
				"label" => $labels["asa_programs"],
				"label_original" => "Programs",
				"label_key" => "asa_programs",
				"label_editable" => true,
			];
			
			// Informational features.
			
			$settings["information"]["about"] = [
				"permission" => $permissions["us_about"],
				"permission_key" => "us_about",
				"permission_editable" => true,
				"label" => $labels["about"],
				"label_original" => "About Us",
				"label_key" => "about",
				"label_editable" => true,
			];
			
			$settings["information"]["services"] = [
				"permission" => $permissions["us_services"],
				"permission_key" => "us_services",
				"permission_editable" => true,
				"label" => $labels["services"],
				"label_original" => "Services",
				"label_key" => "services",
				"label_editable" => true,
			];
			
			$settings["information"]["team"] = [
				"permission" => $permissions["us_team"],
				"permission_key" => "us_team",
				"permission_editable" => true,
				"label" => $labels["team"],
				"label_original" => "Team",
				"label_key" => "team",
				"label_editable" => true,
			];
			
			$settings["information"]["locations"] = [
				"permission" => $permissions["us_locations"],
				"permission_key" => "us_locations",
				"permission_editable" => true,
				"label" => $labels["locations1"],
				"label_original" => "Locations",
				"label_key" => "locations",
				"label_editable" => true,
			];
			
			$settings["information"]["enquiries"] = [
				"permission" => $permissions["us_enquiries"],
				"permission_key" => "us_enquiries",
				"permission_editable" => true,
				"label" => $labels["enquiries"],
				"label_original" => "Enquiries",
				"label_key" => "enquiries",
				"label_editable" => true,
			];
			
			// Fan wall.
			
			$settings_fan_wall = Client::local("settings_fan_wall")->select("recipient_address")->first();
			
			if (strlen($settings_fan_wall->recipient_address)) {
				$fan_wall_recipients = explode(",", $settings_fan_wall->recipient_address);
			} else {
				$fan_wall_recipients = [];
			}
			
			$settings["fan_wall"] = [
				
				"permission" => $permissions["content_fan_wall"],
				"permission_key" => "content_fan_wall",
				"permission_editable" => true,
				"label" => $labels["fan_wall"],
				"label_original" => "Fan Wall",
				"label_key" => "fan_wall",
				"label_editable" => true,
				
				"recipients" => $fan_wall_recipients,
				
				"compose_fan_post" => $labels["compose_fan_post"],
				
			];
			
			// Events.
			
			$settings_events = Client::local("settings_events")->select("recipient_address")->first();
			
			if (strlen($settings_events->recipient_address)) {
				$rsvp_recipients = explode(",", $settings_events->recipient_address);
			} else {
				$rsvp_recipients = [];
			}
			
			$settings["events"] = [
				
				"permission" => $permissions["content_events"],
				"permission_key" => "content_events",
				"permission_editable" => true,
				
				"label" => $labels["events"],
				"label_original" => "Events",
				"label_key" => "events",
				"label_editable" => true,
				
				"rsvp_recipients" => $rsvp_recipients,
				"rsvp_permission" => $permissions["content_rsvp"],
				"rsvp_permission_key" => "content_rsvp",
				"rsvp_label" => "RSVP",
				
			];
			
			// Giving.
			
			$settings["giving"] = [
				
				"permission" => $permissions["us_giving"],
				"permission_key" => "us_giving",
				"permission_editable" => true,
				"label" => $labels["giving"],
				"label_original" => "Giving",
				"label_key" => "giving",
				"label_editable" => true,
				
				"url" => Client::local("settings_giving")->select("url")->value("url"),
				
			];
			
			// Shop.
			
			$settings["shop"] = [
				
				"permission" => $permissions["us_shop"],
				"permission_key" => "us_shop",
				"permission_editable" => true,
				
				"label" => $labels["shop"],
				"label_original" => "Shop",
				"label_key" => "shop",
				"label_editable" => true,
				
				"url" => Client::local("settings_shop")->select("url")->value("url"),
				
			];
			
		}
		
		// Premium features.
		
		$settings["premium"]["user_groups"] = [
			"permission" => $permissions["us_user_groups"],
			"label" => $labels["user_groups"],
			"label_key" => "user_groups",
		];
		
		$settings["premium"]["manual_push"] = [
			"permission" => $permissions["manual_push"],
			"label" => "Manual Push",
		];
		
		$settings["premium"]["automatic_push"] = [
			"permission" => $permissions["automatic_push"],
			"label" => "Automatic Push",
		];
		
		$settings["premium"]["v_social"] = [
			"permission" => $permissions["publish_to_social_media"],
			"label" => "V Social",
		];
		
		$settings["premium"]["analytics"] = [
			"permission" => $permissions["dashboard_analytics"],
			"label" => "Analytics",
		];

		// Content Filters.
		
		$settings["filters"]["location_state_filter"] = [
			"permission" => $permissions["location_state_filter"],
			"label" => "Locations States Filter",
			"permission_key" => "location_state_filter",
			"permission_editable" => true
		];

		$settings["filters"]["sermon_filter"] = [
			"permission" => $permissions["sermon_filter"],
			"label" => "Sermons Filter",
			"permission_key" => "sermon_filter",
			"permission_editable" => true
		];
		
		// Response.
		
		return $response->withJson((new \Vinteract\API\Response([
			"code" => 200,
			"contents" => [ "settings" => $settings ],
		]))->getResponseObject());
		
	});
	
	/*
		Run App
	*/
	
	$app->run();
	
