<?php

namespace Vinteract;

use Illuminate\Database\Capsule\Manager as Capsule;

class DB {
	
	private $databaseConnections = [];
	
	public $capsule = null;
	
	function __construct($databaseConnections = []) {
		
		$this->capsule = new Capsule;
		
		$this->capsule->setAsGlobal();
		
		$this->capsule->bootEloquent();
		
		$this->databaseConnections = $databaseConnections;
		
		if (array_key_exists("default", $this->databaseConnections)) {
			$this->connect("default");
		}
		
	}
	
	function __destruct() {
		
		
		
	}
	
	public function connect($connectionName = null) {
		$this->capsule->addConnection($this->databaseConnections[$connectionName], $connectionName);
	}
	
}
