<?php

namespace Vinteract;

use \Vinteract\Client as Client;

class Features {
	
	/*
		
		Utils
		
	*/
	
	public static function isFeatureEnabled($key) {
		return Client::local("settings_features")->where("key", $key)->value("value") === "true";
	}
	
	public static function areAnyContentFeaturesEnabled() {
		foreach(self::getContentFeatures() as $feature) {
			if ($feature["enabled"] === true) return true;
		}
		return false;
	}
	
	public static function areAnyInformationalFeaturesEnabled() {
		foreach(self::getInformationalFeatures() as $feature) {
			if ($feature["enabled"] === true) return true;
		}
		return false;
	}
	
	public static function getContentFeatures() {
		
		$permissions = array_column(Client::local("settings_features")->get()->toArray(), "value", "key");
		$labels = array_column(Client::local("settings_labels")->get()->toArray(), "value", "key");
		
		if (Client::isChurch()) {
			
			return [
				
				"verses" => [
					"key" => "verses",
					"enabled" => $permissions["content_verses"] === "true",
					"label" => $labels["verses"],
				],
				
				"devotionals" => [
					"key" => "devotionals",
					"enabled" => $permissions["content_events"] === "true",
					"label" => $labels["devotionals"],
				],
				
				"news" => [
					"key" => "news",
					"enabled" => $permissions["content_news"] === "true",
					"label" => $labels["news"],
				],
				
				"newsletters" => [
					"key" => "newsletters",
					"enabled" => $permissions["content_newsletters"] === "true",
					"label" => $labels["newsletters"],
				],
				
				"sermons" => [
					"key" => "sermons",
					"enabled" => $permissions["content_sermons"] === "true",
					"label" => $labels["sermons"],
				],
				
				"prayer_requests" => [
					"key" => "prayer_requests",
					"enabled" => $permissions["content_prayer_requests"] === "true",
					"label" => $labels["prayer_requests"],
				],
				
				"events" => [
					"key" => "events",
					"enabled" => $permissions["content_events"] === "true",
					"label" => $labels["events"],
				],
				
			];
			
		} else {
			
			return [
				
				"asa_programs" => [
					"key" => "asa_programs",
					"enabled" => $permissions["content_asa_programs"] === "true",
					"label" => $labels["asa_programs"],
				],
				
				"advice" => [
					"key" => "advice",
					"enabled" => $permissions["content_advice"] === "true",
					"label" => $labels["advice"],
				],
				
				"news" => [
					"key" => "news",
					"enabled" => $permissions["content_news"] === "true",
					"label" => $labels["news"],
				],
				
				"newsletters" => [
					"key" => "newsletters",
					"enabled" => $permissions["content_newsletters"] === "true",
					"label" => $labels["newsletters"],
				],
				
				"promotional_content" => [
					"key" => "promotional_content",
					"enabled" => $permissions["content_promotional_content"] === "true",
					"label" => $labels["promotional_content"],
				],
				
				"events" => [
					"key" => "events",
					"enabled" => $permissions["content_events"] === "true",
					"label" => $labels["events"],
				],
				
				"fan_wall" => [
					"key" => "fan_wall",
					"enabled" => $permissions["content_fan_wall"] === "true",
					"label" => $labels["fan_wall"],
				],
				
				"offers" => [
					"key" => "offers",
					"enabled" => $permissions["content_offers"] === "true",
					"label" => $labels["offers"],
				],
				
			];
			
		}
		
	}
	
	public static function getInformationalFeatures() {
		
		$permissions = array_column(Client::local("settings_features")->get()->toArray(), "value", "key");
		$labels = array_column(Client::local("settings_labels")->get()->toArray(), "value", "key");
		
		if (Client::isChurch()) {
			
			return [
				
				"about" => [
					"key" => "about",
					"enabled" => $permissions["us_about"] === "true",
					"label" => $labels["about"],
				],
				
				"ministries" => [
					"key" => "ministries",
					"enabled" => $permissions["us_ministries"] === "true",
					"label" => $labels["ministries"],
				],
				
				"church_locations" => [
					"key" => "church_locations",
					"enabled" => $permissions["us_church_locations"] === "true",
					"label" => $labels["locations2"],
				],
				
				"team" => [
					"key" => "team",
					"enabled" => $permissions["us_team"] === "true",
					"label" => $labels["team"],
				],
				
				"enquiries" => [
					"key" => "enquiries",
					"enabled" => $permissions["us_enquiries"] === "true",
					"label" => $labels["enquiries"],
				],
				
			];
			
		} else {
			
			return [
				
				"about" => [
					"key" => "about",
					"enabled" => $permissions["us_about"] === "true",
					"label" => $labels["about"],
				],
				
				"services" => [
					"key" => "services",
					"enabled" => $permissions["us_services"] === "true",
					"label" => $labels["services"],
				],
				
				"locations" => [
					"key" => "locations",
					"enabled" => $permissions["us_locations"] === "true",
					"label" => $labels["locations2"],
				],
				
				"team" => [
					"key" => "team",
					"enabled" => $permissions["us_team"] === "true",
					"label" => $labels["team"],
				],
				
				"enquiries" => [
					"key" => "enquiries",
					"enabled" => $permissions["us_enquiries"] === "true",
					"label" => $labels["enquiries"],
				],
				
			];
			
		}
		
	}
	
	public static function getOtherFeatures() {
		
		return [
			
			"manual_notifications" => [
				"key" => "manual_notifications",
				"enabled" => self::manualNotificationsEnabled(),
			],
			
			"queued_notifications" => [
				"key" => "queued_notifications",
				"enabled" => self::queuedNotificationsEnabled(),
			],
			
			"app_push_notifications" => [
				"key" => "app_push_notifications",
				"enabled" => self::appPushNotificationsEnabled(),
			],
			
			"web_push_notifications" => [
				"key" => "web_push_notifications",
				"enabled" => self::webPushNotificationsEnabled(),
			],
			
			"sms_notifications" => [
				"key" => "sms_notifications",
				"enabled" => self::smsNotificationsEnabled(),
				"available_credit" => Client::getSetting("sms_credits"),
			],
			
			"user_groups" => [
				"key" => "v",
				"enabled" => self::userGroupsEnabled(),
			],
			
			"organisations" => [
				"key" => "organisations",
				"enabled" => self::organisationsEnabled(),
			],
			
		];
		
	}
	
	public static function getAllFeatures() {
		return [
			"content" => self::getContentFeatures(),
			"information" => self::getInformationalFeatures(),
			"other" => self::getOtherFeatures(),
		];
	}
	
	/*
		
		Other
		
	*/
	
	public static function dashboardEnabled() {
		return !Client::isPaymentsPlatformOnly();
	}
	
	public static function productionEnabled() {
		return Client::isWebsitePlatformEnabled() or Client::isEnterpriseAppPlatformEnabled() or Client::isChurchCentralPlatformEnabled();
	}
	
	public static function chatRoomsEnabled() {
		return self::isFeatureEnabled("chat_rooms");
	}
	
	public static function newPaymentsEnabled() {
		return self::isFeatureEnabled("vinteract_pay");
	}
	
	public static function oldPaymentsEnabled() {
		return self::isFeatureEnabled("payments");
	}
	
	public static function parentChildEnabled() {
		return self::isFeatureEnabled("parent_child");
	}
	
	/*
		
		Media Library / File Uploads
		
	*/
	
	public static function mediaLibraryEnabled() {
		return self::isFeatureEnabled("video_uploads") or self::isFeatureEnabled("audio_uploads") or self::isFeatureEnabled("document_uploads") or self::isFeatureEnabled("image_uploads");
	}
	
	/*
		
		Segmentation
		
	*/
	
	public static function userGroupsEnabled() {
		return self::isFeatureEnabled("us_user_groups");
	}
	
	public static function organisationsEnabled() {
		return self::isFeatureEnabled("content_organisations");
	}
	
	/*
		
		Notifications
		
	*/
	
	public static function appPushNotificationsEnabled() {
		return self::notificationCentreEnabled() and self::isFeatureEnabled("app_push_notifications") and (\Vinteract\Client::getData("church_central") == "1" or \Vinteract\Client::getData("custom_app") == "1");
	}
	
	public static function webPushNotificationsEnabled() {
		return self::notificationCentreEnabled() and self::isFeatureEnabled("web_push_notifications") and (\Vinteract\Client::getData("website") == "1" and !\Vinteract\Utils::IsNullOrEmptyString(\Vinteract\Client::getData("website_domain")));
	}
	
	public static function smsNotificationsEnabled() {
		return (self::notificationCentreEnabled() and self::isFeatureEnabled("sms_notifications"));
	}
	
	public static function notificationCentreEnabled() {
		return (self::manualNotificationsEnabled() or self::queuedNotificationsEnabled());
	}
	
	public static function manualNotificationsEnabled() {
		return self::isFeatureEnabled("manual_push");
	}
	
	public static function queuedNotificationsEnabled() {
		return self::isFeatureEnabled("automatic_push");
	}
	
}
