<?php

namespace Vinteract\Notifications;

use Vinteract\Resources\Resource;
use Vinteract\API\Response;

class AppPush extends Resource {
	
	/*
		Properties
	*/
	
	const LOGIN_API_URL = "https://api.cloud.appcelerator.com/v1/users/login.json";
	
	const LOGIN_USERNAME = "push123x_admin";
	const LOGIN_PASSWORD = "push123x_admin";
	
	const NOTIFICATION_API_URL = "https://api.cloud.appcelerator.com/v1/push_notification/notify_tokens.json";
	
	const VERIFY_HOST = false;
	const VERIFY_PEER = false;
	
	public $response;
	
	/*
		Constructor
	*/
	
	function __construct($params = []) {
		
		parent::__construct();
		
		$this->__set_data($params);
		
		$this->required = ["api_key", "channel", "payload"];
		
		$this->response = new Response();
		
		//$to, $channel, $users, $user_groups, $organisations, $payload, $tokens
		
	}
	
	/*
		Methods
	*/
	
	private function login() {
		
		$ch = curl_init($this::LOGIN_API_URL . "?key={$this->__get_data("api_key")}");
		
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, $this::VERIFY_HOST);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $this::VERIFY_PEER);
		curl_setopt($ch, CURLOPT_POSTFIELDS, [
			"login" => $this::LOGIN_USERNAME,
			"password" => $this::LOGIN_PASSWORD,
		]);
		
		$response = json_decode(curl_exec($ch));
		
		curl_close($ch);
		
		return $response;
		
	}
	
	private function sendToEveryone() {
		
		$ch = curl_init("https://api.cloud.appcelerator.com/v1/push_notification/notify.json?key={$this->__get_data("api_key")}&_session_id={$this->__get_data("session_id")}");
		
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, $this::VERIFY_HOST);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $this::VERIFY_PEER);
		curl_setopt($ch, CURLOPT_POSTFIELDS, array(
			"payload" => json_encode($this->__get_data("payload")),
			"channel" => $this->__get_data("channel"),
			"to_ids" => "everyone",
		));
		
		$response = json_decode(curl_exec($ch));
		
		curl_close($ch);
		
		return $response;
		
	}
	
	private function sendToTokens() {
		
		$ch = curl_init("https://api.cloud.appcelerator.com/v1/push_notification/notify_tokens.json?key={$this->__get_data("api_key")}&_session_id={$this->__get_data("session_id")}");
		
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, $this::VERIFY_HOST);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $this::VERIFY_PEER);
		curl_setopt($ch, CURLOPT_POSTFIELDS, array(
			"payload" => json_encode($this->__get_data("payload")),
			"channel" => $this->__get_data("channel"),
			"to_tokens" => $this->__get_data("tokens"),
		));
		
		$response = json_decode(curl_exec($ch));
		
		curl_close($ch);
		
		return $response;
		
	}
	
    public function send($params = []) {
		
		// Set data.
		
		$this->__set_data($params);
		
		// Validate required fields before trying to send the SMS.
		
		$this->validate_required_fields();
		
		// Log into the appcelerator cloud.
		
		$loginResponse = $this->login($this->__get_data("api_key"));
		
		// If successully logged in store the session id and send the push notification.
		
		if ($loginResponse->meta->status === "ok") {
			
			$this->__set_data([ "session_id" => $loginResponse->meta->session_id ]);
			
			$tokens = $this->__get_data("tokens");
			
			if (isset($tokens)) {
				$pushResponse = $this->sendToTokens();
			} else {
				$pushResponse = $this->sendToEveryone();
			}
			
			if (property_exists($pushResponse->meta, "code")) {
				$this->response->setCode($pushResponse->meta->code);
			}
			
			if (property_exists($pushResponse->meta, "message")) {
				$this->response->setMessage($pushResponse->meta->message);
			}
			
		}
		
		// Return response.
		
		return $this->response;
		
    }
	
}
