<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	
	<meta name="viewport" content="width=device-width" />
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	
	<title></title>
	
	<style>
		
		/*
			
			GLOBAL
			
		*/
		
		* {
			margin: 0;
			padding: 0;
			font-family: Arial, sans-serif;
			font-size: 100%;
			line-height: 1.6;
		}
		
		img {
			max-width: 100%;
		}
		
		body {
			-webkit-font-smoothing: antialiased;
			-webkit-text-size-adjust: none;
			width: 100%!important;
			height: 100%;
		}
		
		/*
			
			ELEMENTS
			
		*/
		
		a {
			color: #348eda;
			text-decoration: none;
		}
		
		.btn-primary {
			text-decoration: none;
			color: #FFF;
			background-color: #348eda;
			border: solid #348eda;
			border-width: 10px 20px;
			line-height: 2;
			font-weight: bold;
			margin-right: 10px;
			text-align: center;
			cursor: pointer;
			display: inline-block;
			border-radius: 2px;
		}
		
		.btn-secondary {
			text-decoration: none;
			color: #FFF;
			background-color: #aaa;
			border: solid #aaa;
			border-width: 10px 20px;
			line-height: 2;
			font-weight: bold;
			margin-right: 10px;
			text-align: center;
			cursor: pointer;
			display: inline-block;
			border-radius: 2px;
		}
		
		.btn-top-padding {
			padding-top: 20px;
		}
		
		.last {
			margin-bottom: 0;
		}
		
		.first {
			margin-top: 0;
		}
		
		/*
			
			BODY
			
		*/
		
		table.body-wrap {
			/*width: 100%;*/
			padding: 20px;
		}
		
		table.body-wrap .container {
			border: 1px solid #E6E6E6;
		}
		
		/*
			
			LOGO
			
		*/
		
		.content.logo {
			padding: 0;
		}
		
		.content.logo img {
			width: 100%;
			/*border-bottom: 1px solid #F2F2F2;*/
		}
		
		/*
			
			MESSAGE
			
		*/
		
		table.message-wrap td {
			padding: 7.5%;
		}
		
		table.message-wrap p {
			margin-bottom: 20px;
		}
		
		table.message-wrap p:last-of-type {
			margin-bottom: 0;
		}
		
		/*
			
			CMS URL
			
		*/
		
		table.url-wrap {
			width: 100%;	
			clear: both !important;
		}
		
		table.url-wrap {
			text-align: center;
			border-top: 1px solid #F2F2F2;
		}
		
		table.url-wrap td {
			padding: 20px 10%;
		}
		
		table.url-wrap a {
			font-weight: 600;
			font-size: 18px;
		}
		
		/*
			
			FOOTER
			
		*/
		
		table.footer-wrap {
			width: 100%;	
			clear: both !important;
		}
		
		table.footer-wrap {
			text-align: center;
			border-top: 1px solid #F2F2F2;
		}
		
		table.footer-wrap td {
			padding: 40px 10%;
		}
		
		table.footer-wrap p {
			font-size: 13px;
		}
		
		/*
			
			TYPOGRAPHY
			
		*/
		
		h1, h2, h3, h4 {
			color: #333333;
			font-family: Arial, sans-serif;
			line-height: 1.1;
			line-height: 1.2;
			font-weight: 200;
			margin-bottom: 20px;
		}
		
		h1 {
			font-weight: 600;
			font-size: 36px;
		}
		
		h2 {
			font-weight: 600;
			font-size: 28px;
		}
		
		h3 {
			font-weight: 600;
			font-size: 22px;
		}
		
		h4 {
			font-weight: 600;
			font-size: 18px;
		}
		
		p, ul, ol {
			color: #666666;
			font-weight: normal;
			font-size: 15px;
		}
		
		ul li, ol li {
			margin-left: 5px;
			list-style-position: inside;
		}
		
		/*
			
			RESPONSIVENESS
			Nuke it from orbit. It's the only way to be sure.
			
		*/
		
		/* Set a max-width, and make it display as block so it will automatically stretch to that width, but will also shrink down on a phone or something */
		
		.container {
			border-radius: 4px;
			overflow: hidden;
			display: block !important;
			max-width: 800px !important;
			margin: 0 auto !important; /* makes it centered */
			clear: both !important;
		}
		
		/* Set the padding on the td rather than the div for Outlook compatibility */
		
		.body-wrap .container {
			/*padding: 20px;*/
		}
		
		/* This should also be a block element, so that it will fill 100% of the .container */
		
		.content {
			max-width: 800px;
			margin: 0 auto;
			display: block;
		}
		
		/* Let's make sure tables in the content area are 100% wide */
		
		.content table {
			max-width: 800px;
			width: 100%;
		}
		
	</style>
	
</head>

<body bgcolor="#f6f6f6">
	<table class="body-wrap">
		<tr>
			<td class="container" bgcolor="#FFFFFF">
				<div class="content logo">
					<?php if(isset($logo_url)): ?>
						<img src="<?php echo e($logo_url); ?>"/>
					<?php else: ?>
						<img src="http://www.vinteract.com.au/img_new/logo_email.png"/>
					<?php endif; ?>
				</div>
				<div class="content">
					<table class="message-wrap">
						<tr>
							<td>
								<?php if(isset($title)): ?>
									<h3><?php echo e($title); ?></h3>
								<?php endif; ?>
								<?php if(isset($message)): ?>
									<?php echo $message; ?>

								<?php endif; ?>
							</td>
						</tr>
					</table>
				</div>
				<?php if(isset($cms_url)): ?>
					<div class="content">
						<table class="url-wrap">
							<tr>
								<td>
									<a href="<?php echo e(cms_url); ?>" target="blank">View in CMS</a>
								</td>
							</tr>
						</table>
					</div>
				<?php endif; ?>
				<div class="content">
					<table class="footer-wrap">
						<tr>
							<td>
								<p>This is an automated message. Please do not reply directly to this email.</p>
								<?php if(isset($support_hours)): ?>
									<br>
									<p><?php echo e($support_hours); ?></p>
								<?php endif; ?>
								<?php if(isset($copyright)): ?>
									<br>
									<p><?php echo e($copyright); ?></p>
								<?php endif; ?>
							</td>
						</tr>
					</table>
				</div>
			</td>
		</tr>
	</table>
</body>
</html>
<?php /**PATH /home/v/public_html/__websites/packages/vinteract/vinteract/src/Notifications/EmailTemplates/Blade/Views/basic.blade.php ENDPATH**/ ?>