<?php

namespace Vinteract\Payments;

use \Vinteract\Client;

use \Illuminate\Database\Eloquent\Model;

class AccountTrustee extends Model {
	
	/*
		Properties
	*/
	
	public $timestamps = false;
	
	protected $with = ["personnel"];
	
	protected $fillable = ["type", "legal_entity_name", "trading_name", "legal_entity_number", "address_1", "address_2"];
	
	/*
		Overrides
	*/
	
	public function __construct($attributes = []) {
		
		parent::__construct($attributes);
		
		$this->setTable(Client::getName() . "_vpay_account_trustees");
		$this->setConnection(Client::getType());
		
	}
	
	/*
		Relationships
	*/
	
	public function personnel() {
        return $this->hasMany("\Vinteract\Payments\AccountTrusteePersonnel", "trustee_id", "id");
    }
	
}
