<?php

namespace Vinteract\Payments\Providers\MerchantWarrior;

use \Vinteract\Payments\Providers\MerchantWarrior\MerchantWarrior as MerchantWarrior;
use \Vinteract\Payments\Providers\MerchantWarrior\Request as MerchantWarriorRequest;
use \Vinteract\Payments\Providers\MerchantWarrior\RequestResponse as MerchantWarriorRequestResponse;

class RecurringTransaction extends MerchantWarriorRequestResponse {
	
	public $response = [];
	
	public function process($postData) {
		
		// Send API request and store the response.
		
		$this->setResponse(MerchantWarriorRequest::send(MerchantWarrior::getApiUrl("TOKENS"), [
			
			"method" => "processCard",
			
			"merchantUUID" => MerchantWarrior::getMerchantUuid(),
			"apiKey" => MerchantWarrior::getMerchantApiKey(),
			
			"customerName" => $postData["customer"]["full_name"],
			"customerCountry" => $postData["customer"]["address"]["country"],
			"customerState" => $postData["customer"]["address"]["state"],
			"customerCity" => $postData["customer"]["address"]["city"],
			"customerAddress" => array_key_exists("street_1", $postData["customer"]["address"]) ? $postData["customer"]["address"]["street_1"] : "No Street Address",
			"customerPostCode" => $postData["customer"]["address"]["postcode"],
			"customerPhone" => $postData["customer"]["mobile"],
			"customerEmail" => $postData["customer"]["email"],
			"customerIP" => $postData["customer"]["ip"],
			
			"transactionProduct" => $postData["transaction"]["description"],
			"transactionAmount" => $postData["transaction"]["amount"],
			"transactionCurrency" => $postData["transaction"]["currency"],
			
			"cardID" =>  urlencode($postData["card"]["token"]),
			
			"hash" => MerchantWarrior::generateHash("processCardToken", [
				$postData["transaction"]["amount"],
				$postData["transaction"]["currency"]
			]),
			
		]));
		
	}
	
}
