<?php

namespace Vinteract\Resources;

use \Vinteract\Client;

use \Illuminate\Database\Eloquent\Model;

use DateTime;

class AuthorisedMobileNumber extends Model {
	
	public $timestamps = false;
	
    protected $table = "authorised_mobile_numbers";
	protected $connection = "default";
	protected $fillable = ["title", "mobile_number"];
	protected $visible = ["id", "title", "mobile_number", "created"];
	
	protected static function boot() {
		
		parent::boot();
		
		static::setEventDispatcher(new \Illuminate\Events\Dispatcher());
		
		static::creating(function($model) {
			$model->org_type = Client::getType();
			$model->org_id = Client::getId();
			$model->created = (new DateTime())->format("c");
		});
		
	}
	
	public function newQuery($excludeDeleted = true) {
		return parent::newQuery($excludeDeleted = true)
			->where("org_type", Client::getType())
			->where("org_id", Client::getId());
	}
	
}