<?php

namespace Vinteract\Resources;

use Exception;
use InvalidArgumentException;

class Resource {
	
	/*
		Properties
	*/
	
	public $data = [];
	
	public $required = [];
	
	/*
		Constructor	
	*/
	
	function __construct() {
		
	}
	
	/*
		Destructor
	*/
	
	function __destruct() {
		
	}
	
	/*
		Methods
	*/
	
	public function validate_required_fields() {
		foreach($this->required as $required) {
			if (!array_key_exists($required, $this->data)) {
				throw new Exception("Missing data '{$required}'");
			}
		}
	}
	
	/*
		Getters
	*/
	
	public function __get_data($key = null) {
		if (isset($key)) {
			if (array_key_exists($key, $this->data)) {
				return $this->data[$key];
			}
			return null;
		}
		return $this->data;
	}
	
	/*
		Setters
	*/
	
	public function __set_data($data) {
		
		if (!isset($data)) {
			throw new InvalidArgumentException("Data is not set");
		}
		
		if (gettype($data) === "array") {
			foreach($data as $key => $value) {
				$this->data[$key] = $value;
			}
		} elseif (gettype($data) === "object") {
			$this->data = get_object_vars($data);
		}
		
	}
	
}
