<?php

namespace Vinteract\Payments\Providers\MerchantWarrior;

use \Vinteract\Payments\Providers\MerchantWarrior\MerchantWarrior as MerchantWarrior;
use \Vinteract\Payments\Providers\MerchantWarrior\Request as MerchantWarriorRequest;
use \Vinteract\Payments\Providers\MerchantWarrior\RequestResponse as MerchantWarriorRequestResponse;

class MerchantAccount extends MerchantWarriorRequestResponse {
	
	public $response = [];
	
	public function get() {
		
		$this->setResponse(MerchantWarriorRequest::send(MerchantWarrior::getApiUrl("PARTNERS"), [
			
			"method" => "checkMerchant",
			
			"partnerUUID" => MerchantWarrior::getPartnerUuid(),
			
			"apiKey" => MerchantWarrior::getPartnerApiKey(),
			"requestReference" => MerchantWarrior::getMerchantRequestReference(),
			
			"hash" => MerchantWarrior::generateHash("checkMerchant", [
				MerchantWarrior::getPartnerUuid(),
				MerchantWarrior::getMerchantRequestReference()
			]),
			
		]));
		
	}
	
	public function process($postData) {
		
		
		
	}
	
}
