<?php

namespace Vinteract\Payments\Providers\MerchantWarrior;

use \Vinteract\Client as Client;

use Vinteract\Payments\Providers\PaymentProvider;

class MerchantWarrior extends PaymentProvider {
	
	const NAME = "MerchantWarrior";
	
	const SANDBOX_MODE = true;
	
	const PARTNER_API_PASSPHRASE = "06jixj2h";
	const PARTNER_API_KEY = "lacurxxg";
	const PARTNER_UUID = "5c6be38416b87";
	
	const API_URL = "https://api.merchantwarrior.com/post/";
	const API_URL_TOKENS = "https://api.merchantwarrior.com/token/";
	const API_URL_PARTNERS = "https://api.merchantwarrior.com/partner/";
	const API_URL_PAYFRAME = "https://api.merchantwarrior.com/payframe/";
	const API_URL_PAYFRAME_SOURCE = "https://secure.merchantwarrior.com/payframe/";
	
	const SANDBOX_API_URL = "https://base.merchantwarrior.com/post/";
	const SANDBOX_API_URL_TOKENS = "https://base.merchantwarrior.com/token/";
	const SANDBOX_API_URL_PARTNERS = "https://base.merchantwarrior.com/partner/";
	const SANDBOX_API_URL_PAYFRAME = "https://base.merchantwarrior.com/payframe/";
	const SANDBOX_API_URL_PAYFRAME_SOURCE = "https://securetest.merchantwarrior.com/payframe/";
	
	public static function boot() {
		
		// Create merchant warrior specific settings.
		
		if (Client::local("vpay_settings")->where("key", "merchant_warrior_merchant_uuid")->doesntExist()) {
			Client::local("vpay_settings")->insert([ "key" => "merchant_warrior_merchant_uuid", "value" => "" ]);
		}
		
		if (Client::local("vpay_settings")->where("key", "merchant_warrior_merchant_request_reference")->doesntExist()) {
			Client::local("vpay_settings")->insert([ "key" => "merchant_warrior_merchant_request_reference", "value" => "" ]);
		}
		
		if (Client::local("vpay_settings")->where("key", "merchant_warrior_api_key")->doesntExist()) {
			Client::local("vpay_settings")->insert([ "key" => "merchant_warrior_api_key", "value" => "" ]);
		}
		
		if (Client::local("vpay_settings")->where("key", "merchant_warrior_api_passphrase")->doesntExist()) {
			Client::local("vpay_settings")->insert([ "key" => "merchant_warrior_api_passphrase", "value" => "" ]);
		}
		
	}
	
	public static function getAccountStatus() {
		return Client::local("vpay_settings")->where("key", "account_status")->value("value");
		/*$status = "inactive";
		if (self::getMerchantRequestReference()) {
			$status = "pending";
			if (self::getMerchantUuid()) {
				$status = "active";
			}
		}
		return $status;*/
	}
	
	public static function getAccountStatusMessage() {
		return Client::local("vpay_settings")->where("key", "account_status_message")->value("value");
		/*switch (self::getAccountStatus()) {
			case "pending":
				return "Your " . \Vinteract\Payments\Payments::getName() . " account is currently being reviewed.";
			case "active":
				return "Your account is active and ready to process payments.";
			default:
				return "Please complete the onboarding process to activate payments.";
		}*/
	}
	
	public static function getName() {
		return self::NAME;
	}
	
	public static function getUrls() {
		return [
			"api" => [
				"standard" => self::getApiUrl(),
				"tokens" => self::getApiUrl("TOKENS"),
				"payframe" => self::getApiUrl("PAYFRAME"),
				"payframe_source" => self::getApiUrl("PAYFRAME_SOURCE"),
			],
		];
	}
	
	public static function getSettings() {
		return [
			"merchant_uuid" => self::getMerchantUuid(),
			"merchant_api_key" => self::getMerchantApiKey(),
			"merchant_account_reference" => self::getMerchantRequestReference(),
		];
	}
	
	public static function isSandboxMode() {
		return self::SANDBOX_MODE === true;
	}
	
	public static function getMerchantRequestReference() {
		return Client::local("vpay_settings")->where("key", "merchant_warrior_merchant_request_reference")->value("value");
	}
	
	public static function getMerchantApiPassphrase() {
		return Client::local("vpay_settings")->where("key", "merchant_warrior_api_passphrase")->value("value");
	}
	
	public static function getMerchantApiKey() {
		return Client::local("vpay_settings")->where("key", "merchant_warrior_api_key")->value("value");
	}
	
	public static function getMerchantUuid() {
		return Client::local("vpay_settings")->where("key", "merchant_warrior_merchant_uuid")->value("value");
	}
	
	public static function getPartnerApiPassphrase() {
		return self::PARTNER_API_PASSPHRASE;
	}
	
	public static function getPartnerApiKey() {
		return self::PARTNER_API_KEY;
	}
	
	public static function getPartnerUuid() {
		return self::PARTNER_UUID;
	}
	
	public static function getApiUrl($type = "") {
		
		$type = strtoupper($type);
		
		if ($type != "") {
			$type = "_{$type}";
		}
		
		if (self::isSandboxMode()) {
			return constant("self::SANDBOX_API_URL{$type}");
		}
		
		return constant("self::API_URL{$type}");
		
	}
	
	public static function generateHash($type = "transactionType", $pieces = []) {
		
		$pieces = implode("", $pieces);
		
		switch ($type) {
			case "transactionType":
			case "refundCard":
			case "processCardToken":
			case "queryCard":
			case "getSettlement":
				$step1 = md5(self::getMerchantApiPassphrase()) . self::getMerchantUuid() . $pieces;
				$step2 = strtolower($step1);
				$step3 = md5($step2);
				return $step3;
				break;
			case "checkMerchant":
			case "addMerchant":
				$step1 = md5(self::getPartnerApiPassphrase()) . self::getPartnerUuid() . $pieces;
				$step2 = strtolower($step1);
				$step3 = md5($step2);
				return $step3;
				break;
			default:
				return "";
				break;
		}
		
	}
	
	public static function getDevTransactionPayload() {
		return [
			"method" => "processCard",
			"merchantUUID" => self::getMerchantUuid(),
			"apiKey" => self::getMerchantApiKey(),
			"transactionAmount" => "100.00",
			"transactionCurrency" => "AUD",
			"transactionProduct" => "Tithe",
			"customerName" => "Simon Burford",
			"customerCountry" => "AU",
			"customerState" => "QLD",
			"customerCity" => "Brisbane",
			"customerAddress" => "123 Test Street",
			"customerPostCode" => "4000",
			"customerPhone" => "61468543991",
			"customerEmail" => "simon@burford.me",
			"customerIP" => "1.1.1.1",
			"paymentCardName" => "Simon Burford",
			"paymentCardNumber" => "5163200000000008",
			"paymentCardExpiry" => "0820",
			"paymentCardCSC" => "070",
			"hash" => MerchantWarrior::generateHash("transactionType", ["100.00", "AUD"]),
		];
	}
	
}
