<?php

namespace Vinteract\Payments\Providers\MerchantWarrior;

use \Vinteract\Payments\Providers\MerchantWarrior\MerchantWarrior as MerchantWarrior;
use \Vinteract\Payments\Providers\MerchantWarrior\FileRequest as MerchantWarriorFileRequest;
use \Vinteract\Payments\Providers\MerchantWarrior\RequestResponse as MerchantWarriorRequestResponse;

class Payouts extends MerchantWarriorRequestResponse {
	
	public $response = [];
	
	public function get($postData) {
		
		// Variables.
		
		$payouts = [];
		
		// Send API request and store the response.
		
		$this->setResponse(MerchantWarriorFileRequest::send(MerchantWarrior::getApiUrl(), [
			
			"method" => "getSettlement",
			
			"merchantUUID" => MerchantWarrior::getMerchantUuid(),
			"apiKey" => MerchantWarrior::getMerchantApiKey(),
			
			"settlementFrom" => $postData["from"],
			"settlementTo" => $postData["to"],
			
			"hash" => MerchantWarrior::generateHash("getSettlement", [
				$postData["from"],
				$postData["to"]
			]),
			
		]));
		
		// Open zip archive and extract settled transactions.
		
		$zip = new \ZipArchive;
		
		if ($zip->open($this->response) === TRUE) {
			
			//$contents = $zip->getFromIndex(0);
			
			// CSV file.
			
			$csv_file = $zip->getFromIndex(0);
			$csv_lines = explode(PHP_EOL, $csv_file);
			
			// Convert CSV lines to array.
			
			$rows = [];
			
			foreach ($csv_lines as $line) {
				$rows[] = str_getcsv($line);
			}
			
			// Get column names.
			
			$columns = array_shift($rows);
			
			// Merge the columns and rows into an associate array.
			
			foreach ($rows as $row) {
				
				$merged = array_combine($columns, $row);
				
				if ($merged) {
					
					$name = explode(" ", $merged["Customer Name"]);
					
					$amount = $merged["Amount"];
					
					$fee = $merged["Fee Gateway"] + ($merged["Amount"] * $merged["Fee Service"]);
					
					$transaction = new \Vinteract\Payments\TransactionRecord();
					
					$transaction->fill([
						"uuid" => $merged["Transaction ID"],
						//"receipt_number" => null,
						//"response_code" => null,
						"status" => $merged["Status"],
						"card_type" => $merged["Card Type"],
						"card_last_4" => $merged["Card Last Four"],
						//"frequency" => null,
						//"interval" => null,
						"amount" => money_format("%.2n", $amount),
						"fee" => money_format("%.2n", $fee),
						"currency" => $merged["Currency"],
						"description" => $merged["Product"],
						"first_name" => $name[0],
						"last_name" => $name[1],
						"email" => $merged["Customer Email"],
						"phone" => $merged["Customer Phone"],
						"street_1" => $merged["Customer Address"],
						//"street_2" => null,
						"city" => $merged["Customer City"],
						"state" => $merged["Customer State"],
						"postcode" => $merged["Customer Postcode"],
						"country" => $merged["Customer Country"],
						//"user_id" => null,
						//"transaction_schedule_id" => null,
						"date" => $merged["Settled Date"],
					]);
					
					//$settled_transactions[] = $merged;
					
					$payouts[] = $transaction;
					
				}
				
			}
			
			// Close the zip file.
			
			$zip->close();
			
		}
		
		// Return payouts.
		
		return $payouts;
		
	}
	
}
