<?php

namespace Vinteract\Payments\Providers\PinPayments;

use \Vinteract\API\Response;

class RequestResponse extends Response {
	
	public function __construct($params = null) {
		parent::__construct($params);
	}
	
	public function getRefundId() {
		return $this->getValue("data.token");
	}
	
	public function getTransactionId() {
		return $this->getValue("data.token");
	}
	
	public function getReceiptNumber() {
		return \Vinteract\Utils::generateRandomNumber(8);
	}
	
	public function getResponseCode() {
		return $this->getValue("code");
	}
	
	public function getStatus() {
		$status = $this->getValue("data.status_message");
		switch ($status) {
			case "Success":
				return "approved";
			default:
				return "other";
		}
	}
	
	public function getError() {
		return $this->getValue("data.error");
	}
	
	public function getFee() {
		return $this->getValue("data.total_fees", 0.00) / 100;
	}
	
	public function getCardType() {
		return $this->getValue("data.card.scheme", "other");
	}
	
	public function getCardNumber() {
		$card_number = $this->getValue("data.card.display_number");
		return substr($card_number, strlen($card_number) - 4);
	}
	
}
