<?php

namespace Vinteract\Payments\Providers\PinPayments\Transfers;

use Vinteract\Payments\Interfaces\TransferLineItemInterface;

class TransferLineItem implements TransferLineItemInterface {
	
	public function __construct($properties = []) {
		foreach($properties as $key => $value) {
	  		$this->{$key} = $value;
	    }
	}
	
	public function getDate() {
		return $this->created_at;
	}
	
	public function getType() {
		return $this->type;
	}
	
	public function getAmount() {
		return $this->amount / 100;
	}
	
	public function getCurrency() {
		return $this->currency;
	}
	
	public function getValue($key) {
		if (property_exists($this, $key)) {
			return $this->$key;
		}
		return false;
	}
	
}
