<?php

namespace Vinteract\Payments;

use \Vinteract\Client;

use \Illuminate\Database\Eloquent\Model;

class Receipt extends Model {
	
	protected $visible = ["receipt_number", "card_type", "card_last_4", "amount", "currency", "description", "first_name", "last_name", "email", "phone", "street_1", "street_2", "city", "state", "postcode", "country", "is_gift", "includes_tax", "user_paid_fees", "date", "notes"];
	
	public function __construct($attributes = []) {
		
		parent::__construct($attributes = []);
		
		$this->setTable(Client::getName() . "_vpay_transactions");
		$this->setConnection(Client::getType());
		
	}
	
	public static function fetch($id = null) {
		if (isset($id)) {
			return self::select()->selectRaw("CONVERT_TZ(date, '+00:00', '" . \Vinteract\Client::getTimezoneOffset() . "') AS date")->where("receipt_number", "like", "%{$id}%")->get();
		}
		return [];
		
	}
	
}
