<?php

namespace Vinteract\Payments;

use \Vinteract\Client;

use \Illuminate\Database\Eloquent\Model;

use \Carbon\Carbon;

class TransactionRecord extends Model {
	
	/*
		Properties
	*/
	
	public $timestamps = false;
	
	/*protected $casts = [
		"receipt_number" => "string",
		"response_code" => "int",
		"amount" => "float",
		"fee" => "float",
		"postcode" => "int",
		"user_id" => "int",
	];*/
	
	//protected $perPage = 1000000;
	
	protected $fillable = [
		"transaction_id",
		"receipt_number",
		"response_code",
		"status",
		"card_type",
		"card_last_4",
		"frequency",
		"interval",
		"amount",
		"fee",
		"platform_fee",
		"currency",
		"description",
		"first_name",
		"last_name",
		"email",
		"phone",
		"street_1",
		"street_2",
		"city",
		"state",
		"postcode",
		"country",
		"is_gift",
		"includes_tax",
		"user_paid_fees",
		"user_id",
		"recurring_transaction_id",
		"product_id",
		"date",
		"notes"
	];
	
	/*
		Overrides
	*/
	
	public function __construct($attributes = []) {
		
		parent::__construct($attributes);
		
		$this->setTable(Client::getName() . "_vpay_transactions");
		$this->setConnection(Client::getType());
		
	}
	
	protected static function boot() {
		parent::boot();
		static::setEventDispatcher(new \Illuminate\Events\Dispatcher());
		static::creating(function($model) {
			$model->provider = \Vinteract\Payments\Payments::getProviderName();
		});
	}
	
	public function newQuery($excludeDeleted = true) {
		return parent::newQuery($excludeDeleted = true)
			->select("*")
			->selectRaw("CONCAT('" . \Vinteract\Payments\Payments::getReceiptURL() . "', receipt_number) AS receipt_url")
			->orderBy("id", "desc");
	}
	
	/*
		Functions
	*/
	
	public static function fetch($id = null, $params = []) {
		
		// Client's timezone.
		
		$timezone = \Vinteract\Client::getTimezone();
		
		// Get query.
		
		$query = self::query();
		
		// Format date in local time.
		
		$query->selectRaw("CONVERT_TZ(date, '+00:00', '" . \Vinteract\Client::getTimezoneOffset() . "') AS date");
		
		// Params / conditions?
		
		if (count($params)) {
			
			if (array_key_exists("from", $params) and array_key_exists("to", $params)) {
				
				$from = Carbon::parse($params["from"], $timezone)->setTimezone("UTC");
				$to = Carbon::parse($params["to"], $timezone)->setTime(23, 59, 59)->setTimezone("UTC");
				
				$query->whereBetween("date", [$from, $to])
					->where(function($q) use($params) {
						if (array_key_exists("keywords", $params)) {
							$q->where("description", "like", "%" . $params["keywords"] . "%")
								->orWhere("first_name", "like", "%" . $params["keywords"] . "%")
								->orWhere("last_name", "like", "%" . $params["keywords"] . "%");
						}
					});
				
			} else {
				
				if (array_key_exists("keywords", $params)) {
					$query->where("description", "like", "%" . $params["keywords"] . "%")
						->orWhere("first_name", "like", "%" . $params["keywords"] . "%")
						->orWhere("last_name", "like", "%" . $params["keywords"] . "%");
				}
				
			}
			
		}
		
		// Select by ID?
		
		if (isset($id)) {
			$query->where("transaction_id", $id);
		}

		$query->with(['refunds']);
		
		// Get result.
		
		return $query->get();
		
	}
	
	/*
		Relationships
	*/
	
	public function refunds() {
        return $this->hasMany("\Vinteract\Payments\RefundRecord", "transaction_id", "id");
    }
	
}
