<?php

namespace Vinteract\CMS;

use \Vinteract\Client;

use \Illuminate\Database\Eloquent\Model;

class DashboardAnnouncement extends Model {
	
	public $timestamps = false;
	
    protected $table = "announcements";
	protected $connection = "default";
	
	public function newQuery($excludeDeleted = true) {
		return parent::newQuery($excludeDeleted = true)
			->where(function($query) {
				$query->where("org_type", Client::getType())
					->orWhere("org_type", null);
			})->where(function($query) {
				$query->where("org_id", Client::getId())
					->orWhere("org_id", null);
			})
			->limit(3)
			->orderBy("id", "desc");
	}
	
}