<?php

namespace Vinteract\Notifications\Email;

use Vinteract\Notifications\Email\ServiceProviderInterface;

use InvalidArgumentException;
use DirectoryIterator;

class Email {
	
	/*
		
		Properties
		
	*/
	
	protected $provider;
	
	/*
		
		Constructor
		
	*/
	
	function __construct($provider) {
		$this->provider = $provider;
	}
	
	/*
		
		Destructor
		
	*/
	
	function __destruct() {
		
	}
	
	/*
		
		Methods
		
	*/
	
	
	
	/*
		
		Getters
		
	*/
	
	public function __get_class_name($file) {
		
		$fp = fopen($file, 'r');
		$class = $namespace = $buffer = '';
		$i = 0;
		
		while (!$class) {
			
			if (feof($fp)) {
				break;
			};
			
			$buffer .= fread($fp, 512);
			$tokens = token_get_all($buffer);
			
			if (strpos($buffer, "{") === false) { continue; };
				
			for (;$i<count($tokens);$i++) {
				
				if ($tokens[$i][0] === T_NAMESPACE) {
					for ($j=$i+1;$j<count($tokens); $j++) {
						if ($tokens[$j][0] === T_STRING) {
							$namespace .= '\\'.$tokens[$j][1];
						} else if ($tokens[$j] === '{' || $tokens[$j] === ';') {
							break;
						}
					}
				}
				
				if ($tokens[$i][0] === T_CLASS) {
					for ($j=$i+1;$j<count($tokens);$j++) {
						if ($tokens[$j] === '{') {
							$class = $tokens[$i+2][1];
						}
					}
				}
				
			}
			
		}
			
		return $class;
		
	}
	
	public function __get_service_providers() {
		
		$providers = [];
		
		$FILES = new DirectoryIterator(__DIR__ . "/ServiceProviders");
		
		foreach ($FILES as $FILE) {
			
		    if($FILE->isDot()) continue;
			
			$providers[] = $this->__get_class_name($FILE->getPath() . "/" . $FILE->getFilename());
			
		}
		
		return $providers;
		
	}
	
	public function __get_name() {
		
		return $this->provider->__get_name();
		
	}
	
	/*
		
		Setters
		
	*/
	
	
	
}
