<?php

namespace Vinteract\Notifications;

class EmailTemplates {
	
	/*
		Utility Functions
	*/
	
	private static function convertToParagraphs($s = "") {
		if (gettype($s) === "array") {
			$s = join("\n", $s);
		}
		return "<p>" . str_replace("\n", "</p><p>", trim($s)) . "</p>";
	}
	
	private static function replaceVariables($html = "", $custom_variables = []) {
		
		// Variables.
		
		$variables = array_merge([
			"{CLIENT_NAME}" => \Vinteract\Client::getDisplayName(),
		], $custom_variables);
		
		// Replace variables.
		
		foreach ($variables as $key => $value) {
			$html = str_replace($key, $value, $html);
		}
		
		// Return html.
		
		return $html;
		
	}
	
	private static function renderTemplateFile($file = "", $variables = []) {
		
		// Variables.
		
		$views = join(DIRECTORY_SEPARATOR, [ __DIR__, "EmailTemplates", "Blade", "Views" ]);
		$cache = join(DIRECTORY_SEPARATOR, [ __DIR__, "EmailTemplates", "Blade", "Cache" ]);
		
		// Instantiate blade.
		
		$blade = new \Jenssegers\Blade\Blade($views, $cache);
		
		// Return rendered template.
		
		return $blade->render($file, $variables);
		
	}
	
	public static function getTemplate($name = "", $variables = []) {
		
		// Variables.
		
		$template = [
			"file" => "basic",
			"subject" => "",
			"variables" => [],
		];
		
		// Get the template if it exists.
		
		if (method_exists(__CLASS__, $name)) {
			$template = self::$name($variables);
		}
		
		// Render the template file.
		
		$html = self::renderTemplateFile($template["file"], $template["variables"]);
		
		// Return the template.
		
		return [
			"subject" => $template["subject"],
			"html" => $html,
		];
		
	}
	
	/*
		Templates
	*/
	
	public static function newUserAuthentication($variables = []) {
		
		if (\Vinteract\Client::hasWebsite()) {
			$message = [
				"Thanks for registering... we're excited to have you onboard!",
				"To activate your account please click on the link below. Once you've activated your account you can log in and make the most of our app and website and their features.",
				"<a href='{AUTHENTICATION_URL}'>Click here to activate your account</a>",
				"See you soon,",
				"<strong>{CLIENT_NAME}</strong>",
			];
		} else {
			$message = [
				"Thanks for registering... we're excited to have you onboard!",
				"To activate your account please click on the link below. Once you've activated your account you can log in and make the most of our app and its features.",
				"<a href='{AUTHENTICATION_URL}'>Click here to activate your account</a>",
				"See you soon,",
				"<strong>{CLIENT_NAME}</strong>",
			];
		}
		
		return [
			"file" => "basic",
			"subject" => "Welcome!",
			"variables" => [
				"logo_url" => \Vinteract\Payments\Payments::getLogoURL(),
				"message" => self::replaceVariables(self::convertToParagraphs($message), $variables),
			],
		];
		
	}
	
	public static function onboardingComplete($variables = []) {
		return [
			"file" => "basic",
			"subject" => "A new client is ready to be onboarded!",
			"variables" => [
				"message" => self::replaceVariables(self::convertToParagraphs([
					"{FULL_NAME} of {CLIENT_NAME} has completed the required fields for " . \Vinteract\Payments\Payments::getName() . " onboarding on {DATE}.",
					"Let's get them up and running team!",
					"You can view their application by clicking <a href='{URL}'>here</a> or paste the URL below into your browser.",
					"{URL}",
				]), $variables),
			],
		];
	}
	
	public static function recurringPaymentSetup($variables = []) {
		return [
			"file" => "basic",
			"subject" => "Your scheduled payment has been setup",
			"variables" => [
				"logo_url" => \Vinteract\Payments\Payments::getLogoURL(),
				"message" => self::replaceVariables(self::convertToParagraphs([
					"Dear {FIRST_NAME},",
					"Thank you, your {INTERVAL} recurring payment of {AMOUNT} {CURRENCY} for {DESCRIPTION} has been setup and is scheduled to start on {START_DATE}.",
					"You can manage your scheduled recurring payments within My Profile.",
					"{CLIENT_NAME}",
				]), $variables),
			],
		];
	}
	
	public static function successfulRecurringPayment($variables = []) {
		return [
			"file" => "basic",
			"subject" => "Your payment receipt",
			"variables" => [
				"logo_url" => \Vinteract\Payments\Payments::getLogoURL(),
				"message" => self::replaceVariables(self::convertToParagraphs([
					"Dear {FIRST_NAME},",
					"Thank you, your {INTERVAL} recurring payment of {AMOUNT} {CURRENCY} for {DESCRIPTION} was successful.",
					"You can view your receipt by clicking <a href='{URL}'>here</a> or paste the URL below into your browser.",
					"{URL}",
					"You can manage your scheduled recurring payments within My Profile.",
					"{CLIENT_NAME}",
				]), $variables),
			],
		];
	}
	
	public static function successfulPayment($variables = []) {
		return [
			"file" => "basic",
			"subject" => "Your payment receipt",
			"variables" => [
				"logo_url" => \Vinteract\Payments\Payments::getLogoURL(),
				"message" => self::replaceVariables(self::convertToParagraphs([
					"Dear {FIRST_NAME},",
					"Thank you, your payment of {AMOUNT} {CURRENCY} for {DESCRIPTION} was successful.",
					"You can view your receipt by clicking <a href='{URL}'>here</a> or paste the URL below into your browser.",
					"{URL}",
					"{CLIENT_NAME}",
				]), $variables),
			],
		];
	}
	
	public static function paymentError($variables = []) {
		return [
			"file" => "basic",
			"subject" => "There was an error with your scheduled payment",
			"variables" => [
				"logo_url" => \Vinteract\Payments\Payments::getLogoURL(),
				"message" => self::replaceVariables(self::convertToParagraphs([
					"Dear {FIRST_NAME},",
					"There was an error processing your scheduled {INTERVAL} recurring payment of {AMOUNT} {CURRENCY} for {DESCRIPTION} on {DATE}:",
					"<strong>{ERROR}</strong>",
					"We will attempt to make the transaction again on {RETRY_DATE}.",
					"You can manage your scheduled recurring payments within My Profile.",
					"{CLIENT_NAME}",
				]), $variables),
			],
		];
	}
	
	public static function paymentCancelled($variables = []) {
		return [
			"file" => "basic",
			"subject" => "Your scheduled payment has been cancelled",
			"variables" => [
				"logo_url" => \Vinteract\Payments\Payments::getLogoURL(),
				"message" => self::replaceVariables(self::convertToParagraphs([
					"Dear {FIRST_NAME},",
					"There was an error processing your scheduled {INTERVAL} recurring payment of {AMOUNT} {CURRENCY} for {DESCRIPTION} on {DATE}:",
					"<strong>{ERROR}</strong>",
					"Your scheduled recurring payment has now been cancelled.",
					"You will need to setup a new scheduled recurring payment.",
					"{CLIENT_NAME}",
				]), $variables),
			],
		];
	}
	
	public static function upcomingPayment($variables = []) {
		return [
			"file" => "basic",
			"subject" => "You have a scheduled payment coming up",
			"variables" => [
				"logo_url" => \Vinteract\Payments\Payments::getLogoURL(),
				"message" => self::replaceVariables(self::convertToParagraphs([
					"Dear {FIRST_NAME},",
					"Just a friendly reminder that your scheduled {INTERVAL} recurring payment of {AMOUNT} {CURRENCY} for {DESCRIPTION} is due to be automatically deducted on {DATE}.",
					"Please ensure you have funds available. You can manage your scheduled recurring payments within My Profile.",
					"{CLIENT_NAME}",
				]), $variables),
			],
		];
	}
	
}
