<?php

namespace Vinteract\Payments\Providers\MerchantWarrior;

use Exception;

class FileRequest {
	
	public static function send($url, $postData) {
		
		// File.
		
		$request_temp_file_path = "./request.zip";
		$request_temp_file = fopen($request_temp_file_path, "w+");
		
		// Execute cURL request.
		
		$curl = curl_init();
		
		curl_setopt($curl, CURLOPT_HEADER, false);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, ENVIRONMENT === "production");
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, ENVIRONMENT === "production" ? 2 : FALSE);
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_FILE, $request_temp_file);
		curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($postData, "", "&"));
		
		$response = curl_exec($curl);
		$error = curl_error($curl);
		
		// Check for CURL errors.
		
		if (isset($error) && strlen($error)) {
			throw new Exception("CURL Error: {$error}");
		}
		
		// Close connections.
		
		curl_close($curl);
		
		fclose($request_temp_file);
		
		// Response.
		
		return $request_temp_file_path;
		
	}
	
}
