<?php

namespace Vinteract\Payments\Providers\MerchantWarrior;

use \Vinteract\Payments\Providers\MerchantWarrior\MerchantWarrior as MerchantWarrior;
use \Vinteract\Payments\Providers\MerchantWarrior\Request as MerchantWarriorRequest;
use \Vinteract\Payments\Providers\MerchantWarrior\RequestResponse as MerchantWarriorRequestResponse;

class Refund extends MerchantWarriorRequestResponse {
	
	public $response = [];
	
	public function process($postData) {
		
		// Send API request and store the response.
		
		$this->setResponse(MerchantWarriorRequest::send(MerchantWarrior::getApiUrl(), [
			
			"method" => "refundCard",
			
			"merchantUUID" => MerchantWarrior::getMerchantUuid(),
			"apiKey" => MerchantWarrior::getMerchantApiKey(),
			
			"transactionAmount" => "{$postData["transaction"]["amount"]}",
			"transactionCurrency" => $postData["transaction"]["currency"],
			"transactionID" => $postData["transaction"]["uuid"],
			"refundAmount" => "{$postData["refund"]["amount"]}",
			
			"hash" => MerchantWarrior::generateHash("refundCard", [
				$postData["transaction"]["amount"],
				$postData["transaction"]["currency"]
			]),
			
		]));
		
	}
	
}
