<?php

namespace Vinteract\Payments\Providers\MerchantWarrior;

class RequestResponse {
	
	public $response = [];
	
	public function setResponse($response) {
		$this->response = $response;
	}
	
	public function getResponseData($key = "") {
		if (array_key_exists("data", $this->response) and array_key_exists($key, $this->response["data"])) {
			return $this->response["data"][$key];
		}
		return "";
	}
	
	public function success() {
		if (array_key_exists("success", $this->response) and $this->response["success"] === true) {
			return true;
		}
		return false;
	}
	
	public function error() {
		if (array_key_exists("error", $this->response) and $this->response["error"] === true) {
			return true;
		}
		return false;
	}
	
	public function getErrorMessage() {
		return $this->getResponseData("responseMessage");
	}
	
	public function getUuid() {
		return $this->getResponseData("transactionID");
	}
	
	public function getReceiptNumber() {
		return $this->getResponseData("receiptNo");
	}
	
	public function getResponseCode() {
		return $this->getResponseData("responseCode");
	}
	
	public function getStatus() {
		return $this->getResponseCode() === "0" ? "approved" : "rejected";
	}
	
	public function getFee() {
		return $this->getResponseData("feeAmount");
	}
	
	public function getCardType() {
		return $this->getResponseData("cardType");
	}
	
	public function getCardNumber() {
		return substr($this->getResponseData("paymentCardNumber"), strlen($this->getResponseData("paymentCardNumber")) - 4);
	}

	
	
}
