<?php

namespace Vinteract\Payments\Providers\PinPayments;

class Transaction {
	
	public function process($postData) {
		
		// Create request instance.
		
		$request = new \Vinteract\Payments\Providers\PinPayments\Request("POST");
		
		// Process request and get the response.
		
		$requestPayload = [
			"email" => $postData["customer"]["email"],
			"description" => $postData["transaction"]["description"],
			"amount" => $postData["transaction"]["amount"] * 100,
			"ip_address" => $postData["customer"]["ip"],
			"currency" => $postData["transaction"]["currency"],
		];
		
		if (array_key_exists("token", $postData["card"])) {
			$requestPayload["card_token"] = $postData["card"]["token"];
		}
		
		if (array_key_exists("token", $postData["customer"])) {
			$requestPayload["customer_token"] = $postData["customer"]["token"];
		}
		
		$response = $request->process(\Vinteract\Payments\Providers\PinPayments\PinPayments::getRequestUrl("charges"), $requestPayload);
		
		// Return the response.
		
		return $response;
		
	}
	
}
