<?php

namespace Vinteract\Payments;

class Settlement {
	
	public function get($params = []) {
		
		$transfersCollection = (new \Vinteract\Payments\TransferRequest())->process($params);
		
		$transfers = [];
		
		foreach($transfersCollection->getItems() as $transfer) {
			$transfers[] = [
				"payment_date" => $transfer->getPaymentDate(),
				"status" => ucfirst($transfer->getStatus()),
				"amount" => $transfer->getAmount(),
				"debits" => $transfer->getDebits(),
				"credits" => $transfer->getCredits(),
				"description" => $transfer->getDescription(),
				"currency" => $transfer->getCurrency(),
				"items" => $transfer->getLineItems(),
			];
		}
		
		return $transfers;
		
	}
	
}
