<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace Carbon;

use Carbon\Traits\Date;
use DateTime;

/**
 * A simple API extension for DateTime.
 *
 * <autodoc generated by `composer phpdoc`>
 *
 * @property      int            $year
 * @property      int            $yearIso
 * @property      int            $month
 * @property      int            $day
 * @property      int            $hour
 * @property      int            $minute
 * @property      int            $second
 * @property      int            $micro
 * @property      int            $microsecond
 * @property      int            $timestamp                                                                            seconds since the Unix Epoch
 * @property      string         $englishDayOfWeek                                                                     the day of week in English
 * @property      string         $shortEnglishDayOfWeek                                                                the abbreviated day of week in English
 * @property      string         $englishMonth                                                                         the month in English
 * @property      string         $shortEnglishMonth                                                                    the abbreviated month in English
 * @property      string         $localeDayOfWeek                                                                      the day of week in current locale LC_TIME
 * @property      string         $shortLocaleDayOfWeek                                                                 the abbreviated day of week in current locale LC_TIME
 * @property      string         $localeMonth                                                                          the month in current locale LC_TIME
 * @property      string         $shortLocaleMonth                                                                     the abbreviated month in current locale LC_TIME
 * @property      int            $milliseconds
 * @property      int            $millisecond
 * @property      int            $milli
 * @property      int            $week                                                                                 1 through 53
 * @property      int            $isoWeek                                                                              1 through 53
 * @property      int            $weekYear                                                                             year according to week format
 * @property      int            $isoWeekYear                                                                          year according to ISO week format
 * @property      int            $dayOfYear                                                                            1 through 366
 * @property      int            $age                                                                                  does a diffInYears() with default parameters
 * @property      int            $offset                                                                               the timezone offset in seconds from UTC
 * @property      int            $offsetMinutes                                                                        the timezone offset in minutes from UTC
 * @property      int            $offsetHours                                                                          the timezone offset in hours from UTC
 * @property      CarbonTimeZone $timezone                                                                             the current timezone
 * @property      CarbonTimeZone $tz                                                                                   alias of $timezone
 * @property-read int            $dayOfWeek                                                                            0 (for Sunday) through 6 (for Saturday)
 * @property-read int            $dayOfWeekIso                                                                         1 (for Monday) through 7 (for Sunday)
 * @property-read int            $weekOfYear                                                                           ISO-8601 week number of year, weeks starting on Monday
 * @property-read int            $daysInMonth                                                                          number of days in the given month
 * @property-read string         $latinMeridiem                                                                        "am"/"pm" (Ante meridiem or Post meridiem latin lowercase mark)
 * @property-read string         $latinUpperMeridiem                                                                   "AM"/"PM" (Ante meridiem or Post meridiem latin uppercase mark)
 * @property-read string         $dayName                                                                              long name of weekday translated according to Carbon locale, in english if no translation available for current language
 * @property-read string         $shortDayName                                                                         short name of weekday translated according to Carbon locale, in english if no translation available for current language
 * @property-read string         $minDayName                                                                           very short name of weekday translated according to Carbon locale, in english if no translation available for current language
 * @property-read string         $monthName                                                                            long name of month translated according to Carbon locale, in english if no translation available for current language
 * @property-read string         $shortMonthName                                                                       short name of month translated according to Carbon locale, in english if no translation available for current language
 * @property-read string         $meridiem                                                                             lowercase meridiem mark translated according to Carbon locale, in latin if no translation available for current language
 * @property-read string         $upperMeridiem                                                                        uppercase meridiem mark translated according to Carbon locale, in latin if no translation available for current language
 * @property-read int            $noZeroHour                                                                           current hour from 1 to 24
 * @property-read int            $weeksInYear                                                                          51 through 53
 * @property-read int            $isoWeeksInYear                                                                       51 through 53
 * @property-read int            $weekOfMonth                                                                          1 through 5
 * @property-read int            $weekNumberInMonth                                                                    1 through 5
 * @property-read int            $firstWeekDay                                                                         0 through 6
 * @property-read int            $lastWeekDay                                                                          0 through 6
 * @property-read int            $daysInYear                                                                           365 or 366
 * @property-read int            $quarter                                                                              the quarter of this instance, 1 - 4
 * @property-read int            $decade                                                                               the decade of this instance
 * @property-read int            $century                                                                              the century of this instance
 * @property-read int            $millennium                                                                           the millennium of this instance
 * @property-read bool           $dst                                                                                  daylight savings time indicator, true if DST, false otherwise
 * @property-read bool           $local                                                                                checks if the timezone is local, true if local, false otherwise
 * @property-read bool           $utc                                                                                  checks if the timezone is UTC, true if UTC, false otherwise
 * @property-read string         $timezoneName                                                                         the current timezone name
 * @property-read string         $tzName                                                                               alias of $timezoneName
 * @property-read string         $timezoneAbbreviatedName                                                              the current timezone abbreviated name
 * @property-read string         $tzAbbrName                                                                           alias of $timezoneAbbreviatedName
 * @property-read string         $locale                                                                               locale of the current instance
 *
 * @method        bool           isUtc()                                                                               Check if the current instance has UTC timezone. (Both isUtc and isUTC cases are valid.)
 * @method        bool           isLocal()                                                                             Check if the current instance has non-UTC timezone.
 * @method        bool           isValid()                                                                             Check if the current instance is a valid date.
 * @method        bool           isDST()                                                                               Check if the current instance is in a daylight saving time.
 * @method        bool           isSunday()                                                                            Checks if the instance day is sunday.
 * @method        bool           isMonday()                                                                            Checks if the instance day is monday.
 * @method        bool           isTuesday()                                                                           Checks if the instance day is tuesday.
 * @method        bool           isWednesday()                                                                         Checks if the instance day is wednesday.
 * @method        bool           isThursday()                                                                          Checks if the instance day is thursday.
 * @method        bool           isFriday()                                                                            Checks if the instance day is friday.
 * @method        bool           isSaturday()                                                                          Checks if the instance day is saturday.
 * @method        bool           isSameYear(\Carbon\Carbon|\DateTimeInterface|string|null $date = null)                Checks if the given date is in the same year as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentYear()                                                                       Checks if the instance is in the same year as the current moment.
 * @method        bool           isNextYear()                                                                          Checks if the instance is in the same year as the current moment next year.
 * @method        bool           isLastYear()                                                                          Checks if the instance is in the same year as the current moment last year.
 * @method        bool           isSameWeek(\Carbon\Carbon|\DateTimeInterface|string|null $date = null)                Checks if the given date is in the same week as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentWeek()                                                                       Checks if the instance is in the same week as the current moment.
 * @method        bool           isNextWeek()                                                                          Checks if the instance is in the same week as the current moment next week.
 * @method        bool           isLastWeek()                                                                          Checks if the instance is in the same week as the current moment last week.
 * @method        bool           isSameDay(\Carbon\Carbon|\DateTimeInterface|string|null $date = null)                 Checks if the given date is in the same day as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentDay()                                                                        Checks if the instance is in the same day as the current moment.
 * @method        bool           isNextDay()                                                                           Checks if the instance is in the same day as the current moment next day.
 * @method        bool           isLastDay()                                                                           Checks if the instance is in the same day as the current moment last day.
 * @method        bool           isSameHour(\Carbon\Carbon|\DateTimeInterface|string|null $date = null)                Checks if the given date is in the same hour as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentHour()                                                                       Checks if the instance is in the same hour as the current moment.
 * @method        bool           isNextHour()                                                                          Checks if the instance is in the same hour as the current moment next hour.
 * @method        bool           isLastHour()                                                                          Checks if the instance is in the same hour as the current moment last hour.
 * @method        bool           isSameMinute(\Carbon\Carbon|\DateTimeInterface|string|null $date = null)              Checks if the given date is in the same minute as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentMinute()                                                                     Checks if the instance is in the same minute as the current moment.
 * @method        bool           isNextMinute()                                                                        Checks if the instance is in the same minute as the current moment next minute.
 * @method        bool           isLastMinute()                                                                        Checks if the instance is in the same minute as the current moment last minute.
 * @method        bool           isSameSecond(\Carbon\Carbon|\DateTimeInterface|string|null $date = null)              Checks if the given date is in the same second as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentSecond()                                                                     Checks if the instance is in the same second as the current moment.
 * @method        bool           isNextSecond()                                                                        Checks if the instance is in the same second as the current moment next second.
 * @method        bool           isLastSecond()                                                                        Checks if the instance is in the same second as the current moment last second.
 * @method        bool           isSameMicro(\Carbon\Carbon|\DateTimeInterface|string|null $date = null)               Checks if the given date is in the same microsecond as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentMicro()                                                                      Checks if the instance is in the same microsecond as the current moment.
 * @method        bool           isNextMicro()                                                                         Checks if the instance is in the same microsecond as the current moment next microsecond.
 * @method        bool           isLastMicro()                                                                         Checks if the instance is in the same microsecond as the current moment last microsecond.
 * @method        bool           isSameMicrosecond(\Carbon\Carbon|\DateTimeInterface|string|null $date = null)         Checks if the given date is in the same microsecond as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentMicrosecond()                                                                Checks if the instance is in the same microsecond as the current moment.
 * @method        bool           isNextMicrosecond()                                                                   Checks if the instance is in the same microsecond as the current moment next microsecond.
 * @method        bool           isLastMicrosecond()                                                                   Checks if the instance is in the same microsecond as the current moment last microsecond.
 * @method        bool           isCurrentMonth()                                                                      Checks if the instance is in the same month as the current moment.
 * @method        bool           isNextMonth()                                                                         Checks if the instance is in the same month as the current moment next month.
 * @method        bool           isLastMonth()                                                                         Checks if the instance is in the same month as the current moment last month.
 * @method        bool           isCurrentQuarter()                                                                    Checks if the instance is in the same quarter as the current moment.
 * @method        bool           isNextQuarter()                                                                       Checks if the instance is in the same quarter as the current moment next quarter.
 * @method        bool           isLastQuarter()                                                                       Checks if the instance is in the same quarter as the current moment last quarter.
 * @method        bool           isSameDecade(\Carbon\Carbon|\DateTimeInterface|string|null $date = null)              Checks if the given date is in the same decade as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentDecade()                                                                     Checks if the instance is in the same decade as the current moment.
 * @method        bool           isNextDecade()                                                                        Checks if the instance is in the same decade as the current moment next decade.
 * @method        bool           isLastDecade()                                                                        Checks if the instance is in the same decade as the current moment last decade.
 * @method        bool           isSameCentury(\Carbon\Carbon|\DateTimeInterface|string|null $date = null)             Checks if the given date is in the same century as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentCentury()                                                                    Checks if the instance is in the same century as the current moment.
 * @method        bool           isNextCentury()                                                                       Checks if the instance is in the same century as the current moment next century.
 * @method        bool           isLastCentury()                                                                       Checks if the instance is in the same century as the current moment last century.
 * @method        bool           isSameMillennium(\Carbon\Carbon|\DateTimeInterface|string|null $date = null)          Checks if the given date is in the same millennium as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentMillennium()                                                                 Checks if the instance is in the same millennium as the current moment.
 * @method        bool           isNextMillennium()                                                                    Checks if the instance is in the same millennium as the current moment next millennium.
 * @method        bool           isLastMillennium()                                                                    Checks if the instance is in the same millennium as the current moment last millennium.
 * @method        Carbon         years(int $value)                                                                     Set current instance year to the given value.
 * @method        Carbon         year(int $value)                                                                      Set current instance year to the given value.
 * @method        Carbon         setYears(int $value)                                                                  Set current instance year to the given value.
 * @method        Carbon         setYear(int $value)                                                                   Set current instance year to the given value.
 * @method        Carbon         months(int $value)                                                                    Set current instance month to the given value.
 * @method        Carbon         month(int $value)                                                                     Set current instance month to the given value.
 * @method        Carbon         setMonths(int $value)                                                                 Set current instance month to the given value.
 * @method        Carbon         setMonth(int $value)                                                                  Set current instance month to the given value.
 * @method        Carbon         days(int $value)                                                                      Set current instance day to the given value.
 * @method        Carbon         day(int $value)                                                                       Set current instance day to the given value.
 * @method        Carbon         setDays(int $value)                                                                   Set current instance day to the given value.
 * @method        Carbon         setDay(int $value)                                                                    Set current instance day to the given value.
 * @method        Carbon         hours(int $value)                                                                     Set current instance hour to the given value.
 * @method        Carbon         hour(int $value)                                                                      Set current instance hour to the given value.
 * @method        Carbon         setHours(int $value)                                                                  Set current instance hour to the given value.
 * @method        Carbon         setHour(int $value)                                                                   Set current instance hour to the given value.
 * @method        Carbon         minutes(int $value)                                                                   Set current instance minute to the given value.
 * @method        Carbon         minute(int $value)                                                                    Set current instance minute to the given value.
 * @method        Carbon         setMinutes(int $value)                                                                Set current instance minute to the given value.
 * @method        Carbon         setMinute(int $value)                                                                 Set current instance minute to the given value.
 * @method        Carbon         seconds(int $value)                                                                   Set current instance second to the given value.
 * @method        Carbon         second(int $value)                                                                    Set current instance second to the given value.
 * @method        Carbon         setSeconds(int $value)                                                                Set current instance second to the given value.
 * @method        Carbon         setSecond(int $value)                                                                 Set current instance second to the given value.
 * @method        Carbon         millis(int $value)                                                                    Set current instance millisecond to the given value.
 * @method        Carbon         milli(int $value)                                                                     Set current instance millisecond to the given value.
 * @method        Carbon         setMillis(int $value)                                                                 Set current instance millisecond to the given value.
 * @method        Carbon         setMilli(int $value)                                                                  Set current instance millisecond to the given value.
 * @method        Carbon         milliseconds(int $value)                                                              Set current instance millisecond to the given value.
 * @method        Carbon         millisecond(int $value)                                                               Set current instance millisecond to the given value.
 * @method        Carbon         setMilliseconds(int $value)                                                           Set current instance millisecond to the given value.
 * @method        Carbon         setMillisecond(int $value)                                                            Set current instance millisecond to the given value.
 * @method        Carbon         micros(int $value)                                                                    Set current instance microsecond to the given value.
 * @method        Carbon         micro(int $value)                                                                     Set current instance microsecond to the given value.
 * @method        Carbon         setMicros(int $value)                                                                 Set current instance microsecond to the given value.
 * @method        Carbon         setMicro(int $value)                                                                  Set current instance microsecond to the given value.
 * @method        Carbon         microseconds(int $value)                                                              Set current instance microsecond to the given value.
 * @method        Carbon         microsecond(int $value)                                                               Set current instance microsecond to the given value.
 * @method        Carbon         setMicroseconds(int $value)                                                           Set current instance microsecond to the given value.
 * @method        Carbon         setMicrosecond(int $value)                                                            Set current instance microsecond to the given value.
 * @method        Carbon         addYears(int $value = 1)                                                              Add years (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         addYear()                                                                             Add one year to the instance (using date interval).
 * @method        Carbon         subYears(int $value = 1)                                                              Sub years (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         subYear()                                                                             Sub one year to the instance (using date interval).
 * @method        Carbon         addYearsWithOverflow(int $value = 1)                                                  Add years (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         addYearWithOverflow()                                                                 Add one year to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         subYearsWithOverflow(int $value = 1)                                                  Sub years (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         subYearWithOverflow()                                                                 Sub one year to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         addYearsWithoutOverflow(int $value = 1)                                               Add years (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addYearWithoutOverflow()                                                              Add one year to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subYearsWithoutOverflow(int $value = 1)                                               Sub years (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subYearWithoutOverflow()                                                              Sub one year to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addYearsWithNoOverflow(int $value = 1)                                                Add years (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addYearWithNoOverflow()                                                               Add one year to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subYearsWithNoOverflow(int $value = 1)                                                Sub years (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subYearWithNoOverflow()                                                               Sub one year to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addYearsNoOverflow(int $value = 1)                                                    Add years (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addYearNoOverflow()                                                                   Add one year to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subYearsNoOverflow(int $value = 1)                                                    Sub years (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subYearNoOverflow()                                                                   Sub one year to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addMonths(int $value = 1)                                                             Add months (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         addMonth()                                                                            Add one month to the instance (using date interval).
 * @method        Carbon         subMonths(int $value = 1)                                                             Sub months (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         subMonth()                                                                            Sub one month to the instance (using date interval).
 * @method        Carbon         addMonthsWithOverflow(int $value = 1)                                                 Add months (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         addMonthWithOverflow()                                                                Add one month to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         subMonthsWithOverflow(int $value = 1)                                                 Sub months (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         subMonthWithOverflow()                                                                Sub one month to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         addMonthsWithoutOverflow(int $value = 1)                                              Add months (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addMonthWithoutOverflow()                                                             Add one month to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subMonthsWithoutOverflow(int $value = 1)                                              Sub months (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subMonthWithoutOverflow()                                                             Sub one month to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addMonthsWithNoOverflow(int $value = 1)                                               Add months (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addMonthWithNoOverflow()                                                              Add one month to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subMonthsWithNoOverflow(int $value = 1)                                               Sub months (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subMonthWithNoOverflow()                                                              Sub one month to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addMonthsNoOverflow(int $value = 1)                                                   Add months (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addMonthNoOverflow()                                                                  Add one month to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subMonthsNoOverflow(int $value = 1)                                                   Sub months (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subMonthNoOverflow()                                                                  Sub one month to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addDays(int $value = 1)                                                               Add days (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         addDay()                                                                              Add one day to the instance (using date interval).
 * @method        Carbon         subDays(int $value = 1)                                                               Sub days (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         subDay()                                                                              Sub one day to the instance (using date interval).
 * @method        Carbon         addHours(int $value = 1)                                                              Add hours (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         addHour()                                                                             Add one hour to the instance (using date interval).
 * @method        Carbon         subHours(int $value = 1)                                                              Sub hours (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         subHour()                                                                             Sub one hour to the instance (using date interval).
 * @method        Carbon         addMinutes(int $value = 1)                                                            Add minutes (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         addMinute()                                                                           Add one minute to the instance (using date interval).
 * @method        Carbon         subMinutes(int $value = 1)                                                            Sub minutes (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         subMinute()                                                                           Sub one minute to the instance (using date interval).
 * @method        Carbon         addSeconds(int $value = 1)                                                            Add seconds (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         addSecond()                                                                           Add one second to the instance (using date interval).
 * @method        Carbon         subSeconds(int $value = 1)                                                            Sub seconds (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         subSecond()                                                                           Sub one second to the instance (using date interval).
 * @method        Carbon         addMillis(int $value = 1)                                                             Add milliseconds (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         addMilli()                                                                            Add one millisecond to the instance (using date interval).
 * @method        Carbon         subMillis(int $value = 1)                                                             Sub milliseconds (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         subMilli()                                                                            Sub one millisecond to the instance (using date interval).
 * @method        Carbon         addMilliseconds(int $value = 1)                                                       Add milliseconds (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         addMillisecond()                                                                      Add one millisecond to the instance (using date interval).
 * @method        Carbon         subMilliseconds(int $value = 1)                                                       Sub milliseconds (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         subMillisecond()                                                                      Sub one millisecond to the instance (using date interval).
 * @method        Carbon         addMicros(int $value = 1)                                                             Add microseconds (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         addMicro()                                                                            Add one microsecond to the instance (using date interval).
 * @method        Carbon         subMicros(int $value = 1)                                                             Sub microseconds (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         subMicro()                                                                            Sub one microsecond to the instance (using date interval).
 * @method        Carbon         addMicroseconds(int $value = 1)                                                       Add microseconds (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         addMicrosecond()                                                                      Add one microsecond to the instance (using date interval).
 * @method        Carbon         subMicroseconds(int $value = 1)                                                       Sub microseconds (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         subMicrosecond()                                                                      Sub one microsecond to the instance (using date interval).
 * @method        Carbon         addMillennia(int $value = 1)                                                          Add millennia (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         addMillennium()                                                                       Add one millennium to the instance (using date interval).
 * @method        Carbon         subMillennia(int $value = 1)                                                          Sub millennia (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         subMillennium()                                                                       Sub one millennium to the instance (using date interval).
 * @method        Carbon         addMillenniaWithOverflow(int $value = 1)                                              Add millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         addMillenniumWithOverflow()                                                           Add one millennium to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         subMillenniaWithOverflow(int $value = 1)                                              Sub millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         subMillenniumWithOverflow()                                                           Sub one millennium to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         addMillenniaWithoutOverflow(int $value = 1)                                           Add millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addMillenniumWithoutOverflow()                                                        Add one millennium to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subMillenniaWithoutOverflow(int $value = 1)                                           Sub millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subMillenniumWithoutOverflow()                                                        Sub one millennium to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addMillenniaWithNoOverflow(int $value = 1)                                            Add millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addMillenniumWithNoOverflow()                                                         Add one millennium to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subMillenniaWithNoOverflow(int $value = 1)                                            Sub millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subMillenniumWithNoOverflow()                                                         Sub one millennium to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addMillenniaNoOverflow(int $value = 1)                                                Add millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addMillenniumNoOverflow()                                                             Add one millennium to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subMillenniaNoOverflow(int $value = 1)                                                Sub millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subMillenniumNoOverflow()                                                             Sub one millennium to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addCenturies(int $value = 1)                                                          Add centuries (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         addCentury()                                                                          Add one century to the instance (using date interval).
 * @method        Carbon         subCenturies(int $value = 1)                                                          Sub centuries (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         subCentury()                                                                          Sub one century to the instance (using date interval).
 * @method        Carbon         addCenturiesWithOverflow(int $value = 1)                                              Add centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         addCenturyWithOverflow()                                                              Add one century to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         subCenturiesWithOverflow(int $value = 1)                                              Sub centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         subCenturyWithOverflow()                                                              Sub one century to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         addCenturiesWithoutOverflow(int $value = 1)                                           Add centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addCenturyWithoutOverflow()                                                           Add one century to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subCenturiesWithoutOverflow(int $value = 1)                                           Sub centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subCenturyWithoutOverflow()                                                           Sub one century to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addCenturiesWithNoOverflow(int $value = 1)                                            Add centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addCenturyWithNoOverflow()                                                            Add one century to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subCenturiesWithNoOverflow(int $value = 1)                                            Sub centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subCenturyWithNoOverflow()                                                            Sub one century to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addCenturiesNoOverflow(int $value = 1)                                                Add centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addCenturyNoOverflow()                                                                Add one century to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subCenturiesNoOverflow(int $value = 1)                                                Sub centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subCenturyNoOverflow()                                                                Sub one century to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addDecades(int $value = 1)                                                            Add decades (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         addDecade()                                                                           Add one decade to the instance (using date interval).
 * @method        Carbon         subDecades(int $value = 1)                                                            Sub decades (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         subDecade()                                                                           Sub one decade to the instance (using date interval).
 * @method        Carbon         addDecadesWithOverflow(int $value = 1)                                                Add decades (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         addDecadeWithOverflow()                                                               Add one decade to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         subDecadesWithOverflow(int $value = 1)                                                Sub decades (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         subDecadeWithOverflow()                                                               Sub one decade to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         addDecadesWithoutOverflow(int $value = 1)                                             Add decades (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addDecadeWithoutOverflow()                                                            Add one decade to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subDecadesWithoutOverflow(int $value = 1)                                             Sub decades (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subDecadeWithoutOverflow()                                                            Sub one decade to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addDecadesWithNoOverflow(int $value = 1)                                              Add decades (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addDecadeWithNoOverflow()                                                             Add one decade to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subDecadesWithNoOverflow(int $value = 1)                                              Sub decades (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subDecadeWithNoOverflow()                                                             Sub one decade to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addDecadesNoOverflow(int $value = 1)                                                  Add decades (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addDecadeNoOverflow()                                                                 Add one decade to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subDecadesNoOverflow(int $value = 1)                                                  Sub decades (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subDecadeNoOverflow()                                                                 Sub one decade to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addQuarters(int $value = 1)                                                           Add quarters (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         addQuarter()                                                                          Add one quarter to the instance (using date interval).
 * @method        Carbon         subQuarters(int $value = 1)                                                           Sub quarters (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         subQuarter()                                                                          Sub one quarter to the instance (using date interval).
 * @method        Carbon         addQuartersWithOverflow(int $value = 1)                                               Add quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         addQuarterWithOverflow()                                                              Add one quarter to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         subQuartersWithOverflow(int $value = 1)                                               Sub quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         subQuarterWithOverflow()                                                              Sub one quarter to the instance (using date interval) with overflow explicitly allowed.
 * @method        Carbon         addQuartersWithoutOverflow(int $value = 1)                                            Add quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addQuarterWithoutOverflow()                                                           Add one quarter to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subQuartersWithoutOverflow(int $value = 1)                                            Sub quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subQuarterWithoutOverflow()                                                           Sub one quarter to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addQuartersWithNoOverflow(int $value = 1)                                             Add quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addQuarterWithNoOverflow()                                                            Add one quarter to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subQuartersWithNoOverflow(int $value = 1)                                             Sub quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subQuarterWithNoOverflow()                                                            Sub one quarter to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addQuartersNoOverflow(int $value = 1)                                                 Add quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addQuarterNoOverflow()                                                                Add one quarter to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subQuartersNoOverflow(int $value = 1)                                                 Sub quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         subQuarterNoOverflow()                                                                Sub one quarter to the instance (using date interval) with overflow explicitly forbidden.
 * @method        Carbon         addWeeks(int $value = 1)                                                              Add weeks (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         addWeek()                                                                             Add one week to the instance (using date interval).
 * @method        Carbon         subWeeks(int $value = 1)                                                              Sub weeks (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         subWeek()                                                                             Sub one week to the instance (using date interval).
 * @method        Carbon         addWeekdays(int $value = 1)                                                           Add weekdays (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         addWeekday()                                                                          Add one weekday to the instance (using date interval).
 * @method        Carbon         subWeekdays(int $value = 1)                                                           Sub weekdays (the $value count passed in) to the instance (using date interval).
 * @method        Carbon         subWeekday()                                                                          Sub one weekday to the instance (using date interval).
 * @method        Carbon         addRealMicros(int $value = 1)                                                         Add microseconds (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         addRealMicro()                                                                        Add one microsecond to the instance (using timestamp).
 * @method        Carbon         subRealMicros(int $value = 1)                                                         Sub microseconds (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         subRealMicro()                                                                        Sub one microsecond to the instance (using timestamp).
 * @method        CarbonPeriod   microsUntil($endDate = null, int $factor = 1)                                         Return an iterable period from current date to given end (string, DateTime or Carbon instance) for each microsecond or every X microseconds if a factor is given.
 * @method        Carbon         addRealMicroseconds(int $value = 1)                                                   Add microseconds (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         addRealMicrosecond()                                                                  Add one microsecond to the instance (using timestamp).
 * @method        Carbon         subRealMicroseconds(int $value = 1)                                                   Sub microseconds (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         subRealMicrosecond()                                                                  Sub one microsecond to the instance (using timestamp).
 * @method        CarbonPeriod   microsecondsUntil($endDate = null, int $factor = 1)                                   Return an iterable period from current date to given end (string, DateTime or Carbon instance) for each microsecond or every X microseconds if a factor is given.
 * @method        Carbon         addRealMillis(int $value = 1)                                                         Add milliseconds (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         addRealMilli()                                                                        Add one millisecond to the instance (using timestamp).
 * @method        Carbon         subRealMillis(int $value = 1)                                                         Sub milliseconds (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         subRealMilli()                                                                        Sub one millisecond to the instance (using timestamp).
 * @method        CarbonPeriod   millisUntil($endDate = null, int $factor = 1)                                         Return an iterable period from current date to given end (string, DateTime or Carbon instance) for each millisecond or every X milliseconds if a factor is given.
 * @method        Carbon         addRealMilliseconds(int $value = 1)                                                   Add milliseconds (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         addRealMillisecond()                                                                  Add one millisecond to the instance (using timestamp).
 * @method        Carbon         subRealMilliseconds(int $value = 1)                                                   Sub milliseconds (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         subRealMillisecond()                                                                  Sub one millisecond to the instance (using timestamp).
 * @method        CarbonPeriod   millisecondsUntil($endDate = null, int $factor = 1)                                   Return an iterable period from current date to given end (string, DateTime or Carbon instance) for each millisecond or every X milliseconds if a factor is given.
 * @method        Carbon         addRealSeconds(int $value = 1)                                                        Add seconds (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         addRealSecond()                                                                       Add one second to the instance (using timestamp).
 * @method        Carbon         subRealSeconds(int $value = 1)                                                        Sub seconds (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         subRealSecond()                                                                       Sub one second to the instance (using timestamp).
 * @method        CarbonPeriod   secondsUntil($endDate = null, int $factor = 1)                                        Return an iterable period from current date to given end (string, DateTime or Carbon instance) for each second or every X seconds if a factor is given.
 * @method        Carbon         addRealMinutes(int $value = 1)                                                        Add minutes (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         addRealMinute()                                                                       Add one minute to the instance (using timestamp).
 * @method        Carbon         subRealMinutes(int $value = 1)                                                        Sub minutes (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         subRealMinute()                                                                       Sub one minute to the instance (using timestamp).
 * @method        CarbonPeriod   minutesUntil($endDate = null, int $factor = 1)                                        Return an iterable period from current date to given end (string, DateTime or Carbon instance) for each minute or every X minutes if a factor is given.
 * @method        Carbon         addRealHours(int $value = 1)                                                          Add hours (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         addRealHour()                                                                         Add one hour to the instance (using timestamp).
 * @method        Carbon         subRealHours(int $value = 1)                                                          Sub hours (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         subRealHour()                                                                         Sub one hour to the instance (using timestamp).
 * @method        CarbonPeriod   hoursUntil($endDate = null, int $factor = 1)                                          Return an iterable period from current date to given end (string, DateTime or Carbon instance) for each hour or every X hours if a factor is given.
 * @method        Carbon         addRealDays(int $value = 1)                                                           Add days (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         addRealDay()                                                                          Add one day to the instance (using timestamp).
 * @method        Carbon         subRealDays(int $value = 1)                                                           Sub days (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         subRealDay()                                                                          Sub one day to the instance (using timestamp).
 * @method        CarbonPeriod   daysUntil($endDate = null, int $factor = 1)                                           Return an iterable period from current date to given end (string, DateTime or Carbon instance) for each day or every X days if a factor is given.
 * @method        Carbon         addRealWeeks(int $value = 1)                                                          Add weeks (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         addRealWeek()                                                                         Add one week to the instance (using timestamp).
 * @method        Carbon         subRealWeeks(int $value = 1)                                                          Sub weeks (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         subRealWeek()                                                                         Sub one week to the instance (using timestamp).
 * @method        CarbonPeriod   weeksUntil($endDate = null, int $factor = 1)                                          Return an iterable period from current date to given end (string, DateTime or Carbon instance) for each week or every X weeks if a factor is given.
 * @method        Carbon         addRealMonths(int $value = 1)                                                         Add months (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         addRealMonth()                                                                        Add one month to the instance (using timestamp).
 * @method        Carbon         subRealMonths(int $value = 1)                                                         Sub months (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         subRealMonth()                                                                        Sub one month to the instance (using timestamp).
 * @method        CarbonPeriod   monthsUntil($endDate = null, int $factor = 1)                                         Return an iterable period from current date to given end (string, DateTime or Carbon instance) for each month or every X months if a factor is given.
 * @method        Carbon         addRealQuarters(int $value = 1)                                                       Add quarters (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         addRealQuarter()                                                                      Add one quarter to the instance (using timestamp).
 * @method        Carbon         subRealQuarters(int $value = 1)                                                       Sub quarters (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         subRealQuarter()                                                                      Sub one quarter to the instance (using timestamp).
 * @method        CarbonPeriod   quartersUntil($endDate = null, int $factor = 1)                                       Return an iterable period from current date to given end (string, DateTime or Carbon instance) for each quarter or every X quarters if a factor is given.
 * @method        Carbon         addRealYears(int $value = 1)                                                          Add years (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         addRealYear()                                                                         Add one year to the instance (using timestamp).
 * @method        Carbon         subRealYears(int $value = 1)                                                          Sub years (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         subRealYear()                                                                         Sub one year to the instance (using timestamp).
 * @method        CarbonPeriod   yearsUntil($endDate = null, int $factor = 1)                                          Return an iterable period from current date to given end (string, DateTime or Carbon instance) for each year or every X years if a factor is given.
 * @method        Carbon         addRealDecades(int $value = 1)                                                        Add decades (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         addRealDecade()                                                                       Add one decade to the instance (using timestamp).
 * @method        Carbon         subRealDecades(int $value = 1)                                                        Sub decades (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         subRealDecade()                                                                       Sub one decade to the instance (using timestamp).
 * @method        CarbonPeriod   decadesUntil($endDate = null, int $factor = 1)                                        Return an iterable period from current date to given end (string, DateTime or Carbon instance) for each decade or every X decades if a factor is given.
 * @method        Carbon         addRealCenturies(int $value = 1)                                                      Add centuries (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         addRealCentury()                                                                      Add one century to the instance (using timestamp).
 * @method        Carbon         subRealCenturies(int $value = 1)                                                      Sub centuries (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         subRealCentury()                                                                      Sub one century to the instance (using timestamp).
 * @method        CarbonPeriod   centuriesUntil($endDate = null, int $factor = 1)                                      Return an iterable period from current date to given end (string, DateTime or Carbon instance) for each century or every X centuries if a factor is given.
 * @method        Carbon         addRealMillennia(int $value = 1)                                                      Add millennia (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         addRealMillennium()                                                                   Add one millennium to the instance (using timestamp).
 * @method        Carbon         subRealMillennia(int $value = 1)                                                      Sub millennia (the $value count passed in) to the instance (using timestamp).
 * @method        Carbon         subRealMillennium()                                                                   Sub one millennium to the instance (using timestamp).
 * @method        CarbonPeriod   millenniaUntil($endDate = null, int $factor = 1)                                      Return an iterable period from current date to given end (string, DateTime or Carbon instance) for each millennium or every X millennia if a factor is given.
 * @method        Carbon         roundYear(float $precision = 1, string $function = "round")                           Round the current instance year with given precision using the given function.
 * @method        Carbon         roundYears(float $precision = 1, string $function = "round")                          Round the current instance year with given precision using the given function.
 * @method        Carbon         floorYear(float $precision = 1)                                                       Truncate the current instance year with given precision.
 * @method        Carbon         floorYears(float $precision = 1)                                                      Truncate the current instance year with given precision.
 * @method        Carbon         ceilYear(float $precision = 1)                                                        Ceil the current instance year with given precision.
 * @method        Carbon         ceilYears(float $precision = 1)                                                       Ceil the current instance year with given precision.
 * @method        Carbon         roundMonth(float $precision = 1, string $function = "round")                          Round the current instance month with given precision using the given function.
 * @method        Carbon         roundMonths(float $precision = 1, string $function = "round")                         Round the current instance month with given precision using the given function.
 * @method        Carbon         floorMonth(float $precision = 1)                                                      Truncate the current instance month with given precision.
 * @method        Carbon         floorMonths(float $precision = 1)                                                     Truncate the current instance month with given precision.
 * @method        Carbon         ceilMonth(float $precision = 1)                                                       Ceil the current instance month with given precision.
 * @method        Carbon         ceilMonths(float $precision = 1)                                                      Ceil the current instance month with given precision.
 * @method        Carbon         roundDay(float $precision = 1, string $function = "round")                            Round the current instance day with given precision using the given function.
 * @method        Carbon         roundDays(float $precision = 1, string $function = "round")                           Round the current instance day with given precision using the given function.
 * @method        Carbon         floorDay(float $precision = 1)                                                        Truncate the current instance day with given precision.
 * @method        Carbon         floorDays(float $precision = 1)                                                       Truncate the current instance day with given precision.
 * @method        Carbon         ceilDay(float $precision = 1)                                                         Ceil the current instance day with given precision.
 * @method        Carbon         ceilDays(float $precision = 1)                                                        Ceil the current instance day with given precision.
 * @method        Carbon         roundHour(float $precision = 1, string $function = "round")                           Round the current instance hour with given precision using the given function.
 * @method        Carbon         roundHours(float $precision = 1, string $function = "round")                          Round the current instance hour with given precision using the given function.
 * @method        Carbon         floorHour(float $precision = 1)                                                       Truncate the current instance hour with given precision.
 * @method        Carbon         floorHours(float $precision = 1)                                                      Truncate the current instance hour with given precision.
 * @method        Carbon         ceilHour(float $precision = 1)                                                        Ceil the current instance hour with given precision.
 * @method        Carbon         ceilHours(float $precision = 1)                                                       Ceil the current instance hour with given precision.
 * @method        Carbon         roundMinute(float $precision = 1, string $function = "round")                         Round the current instance minute with given precision using the given function.
 * @method        Carbon         roundMinutes(float $precision = 1, string $function = "round")                        Round the current instance minute with given precision using the given function.
 * @method        Carbon         floorMinute(float $precision = 1)                                                     Truncate the current instance minute with given precision.
 * @method        Carbon         floorMinutes(float $precision = 1)                                                    Truncate the current instance minute with given precision.
 * @method        Carbon         ceilMinute(float $precision = 1)                                                      Ceil the current instance minute with given precision.
 * @method        Carbon         ceilMinutes(float $precision = 1)                                                     Ceil the current instance minute with given precision.
 * @method        Carbon         roundSecond(float $precision = 1, string $function = "round")                         Round the current instance second with given precision using the given function.
 * @method        Carbon         roundSeconds(float $precision = 1, string $function = "round")                        Round the current instance second with given precision using the given function.
 * @method        Carbon         floorSecond(float $precision = 1)                                                     Truncate the current instance second with given precision.
 * @method        Carbon         floorSeconds(float $precision = 1)                                                    Truncate the current instance second with given precision.
 * @method        Carbon         ceilSecond(float $precision = 1)                                                      Ceil the current instance second with given precision.
 * @method        Carbon         ceilSeconds(float $precision = 1)                                                     Ceil the current instance second with given precision.
 * @method        Carbon         roundMillennium(float $precision = 1, string $function = "round")                     Round the current instance millennium with given precision using the given function.
 * @method        Carbon         roundMillennia(float $precision = 1, string $function = "round")                      Round the current instance millennium with given precision using the given function.
 * @method        Carbon         floorMillennium(float $precision = 1)                                                 Truncate the current instance millennium with given precision.
 * @method        Carbon         floorMillennia(float $precision = 1)                                                  Truncate the current instance millennium with given precision.
 * @method        Carbon         ceilMillennium(float $precision = 1)                                                  Ceil the current instance millennium with given precision.
 * @method        Carbon         ceilMillennia(float $precision = 1)                                                   Ceil the current instance millennium with given precision.
 * @method        Carbon         roundCentury(float $precision = 1, string $function = "round")                        Round the current instance century with given precision using the given function.
 * @method        Carbon         roundCenturies(float $precision = 1, string $function = "round")                      Round the current instance century with given precision using the given function.
 * @method        Carbon         floorCentury(float $precision = 1)                                                    Truncate the current instance century with given precision.
 * @method        Carbon         floorCenturies(float $precision = 1)                                                  Truncate the current instance century with given precision.
 * @method        Carbon         ceilCentury(float $precision = 1)                                                     Ceil the current instance century with given precision.
 * @method        Carbon         ceilCenturies(float $precision = 1)                                                   Ceil the current instance century with given precision.
 * @method        Carbon         roundDecade(float $precision = 1, string $function = "round")                         Round the current instance decade with given precision using the given function.
 * @method        Carbon         roundDecades(float $precision = 1, string $function = "round")                        Round the current instance decade with given precision using the given function.
 * @method        Carbon         floorDecade(float $precision = 1)                                                     Truncate the current instance decade with given precision.
 * @method        Carbon         floorDecades(float $precision = 1)                                                    Truncate the current instance decade with given precision.
 * @method        Carbon         ceilDecade(float $precision = 1)                                                      Ceil the current instance decade with given precision.
 * @method        Carbon         ceilDecades(float $precision = 1)                                                     Ceil the current instance decade with given precision.
 * @method        Carbon         roundQuarter(float $precision = 1, string $function = "round")                        Round the current instance quarter with given precision using the given function.
 * @method        Carbon         roundQuarters(float $precision = 1, string $function = "round")                       Round the current instance quarter with given precision using the given function.
 * @method        Carbon         floorQuarter(float $precision = 1)                                                    Truncate the current instance quarter with given precision.
 * @method        Carbon         floorQuarters(float $precision = 1)                                                   Truncate the current instance quarter with given precision.
 * @method        Carbon         ceilQuarter(float $precision = 1)                                                     Ceil the current instance quarter with given precision.
 * @method        Carbon         ceilQuarters(float $precision = 1)                                                    Ceil the current instance quarter with given precision.
 * @method        Carbon         roundMillisecond(float $precision = 1, string $function = "round")                    Round the current instance millisecond with given precision using the given function.
 * @method        Carbon         roundMilliseconds(float $precision = 1, string $function = "round")                   Round the current instance millisecond with given precision using the given function.
 * @method        Carbon         floorMillisecond(float $precision = 1)                                                Truncate the current instance millisecond with given precision.
 * @method        Carbon         floorMilliseconds(float $precision = 1)                                               Truncate the current instance millisecond with given precision.
 * @method        Carbon         ceilMillisecond(float $precision = 1)                                                 Ceil the current instance millisecond with given precision.
 * @method        Carbon         ceilMilliseconds(float $precision = 1)                                                Ceil the current instance millisecond with given precision.
 * @method        Carbon         roundMicrosecond(float $precision = 1, string $function = "round")                    Round the current instance microsecond with given precision using the given function.
 * @method        Carbon         roundMicroseconds(float $precision = 1, string $function = "round")                   Round the current instance microsecond with given precision using the given function.
 * @method        Carbon         floorMicrosecond(float $precision = 1)                                                Truncate the current instance microsecond with given precision.
 * @method        Carbon         floorMicroseconds(float $precision = 1)                                               Truncate the current instance microsecond with given precision.
 * @method        Carbon         ceilMicrosecond(float $precision = 1)                                                 Ceil the current instance microsecond with given precision.
 * @method        Carbon         ceilMicroseconds(float $precision = 1)                                                Ceil the current instance microsecond with given precision.
 * @method        string         shortAbsoluteDiffForHumans(\DateTimeInterface $other = null, int $parts = 1)          Get the difference (short format, 'Absolute' mode) in a human readable format in the current locale. ($other and $parts parameters can be swapped.)
 * @method        string         longAbsoluteDiffForHumans(\DateTimeInterface $other = null, int $parts = 1)           Get the difference (long format, 'Absolute' mode) in a human readable format in the current locale. ($other and $parts parameters can be swapped.)
 * @method        string         shortRelativeDiffForHumans(\DateTimeInterface $other = null, int $parts = 1)          Get the difference (short format, 'Relative' mode) in a human readable format in the current locale. ($other and $parts parameters can be swapped.)
 * @method        string         longRelativeDiffForHumans(\DateTimeInterface $other = null, int $parts = 1)           Get the difference (long format, 'Relative' mode) in a human readable format in the current locale. ($other and $parts parameters can be swapped.)
 * @method        string         shortRelativeToNowDiffForHumans(\DateTimeInterface $other = null, int $parts = 1)     Get the difference (short format, 'RelativeToNow' mode) in a human readable format in the current locale. ($other and $parts parameters can be swapped.)
 * @method        string         longRelativeToNowDiffForHumans(\DateTimeInterface $other = null, int $parts = 1)      Get the difference (long format, 'RelativeToNow' mode) in a human readable format in the current locale. ($other and $parts parameters can be swapped.)
 * @method        string         shortRelativeToOtherDiffForHumans(\DateTimeInterface $other = null, int $parts = 1)   Get the difference (short format, 'RelativeToOther' mode) in a human readable format in the current locale. ($other and $parts parameters can be swapped.)
 * @method        string         longRelativeToOtherDiffForHumans(\DateTimeInterface $other = null, int $parts = 1)    Get the difference (long format, 'RelativeToOther' mode) in a human readable format in the current locale. ($other and $parts parameters can be swapped.)
 * @method        static Carbon  createFromImmutable(\DateTimeImmutable $dateTime)                                     Create a new Carbon object from an immutable date.
 * @method        static Carbon  createFromFormat(string $format, string $time, string|\DateTimeZone $timezone = null) Parse a string into a new Carbon object according to the specified format.
 * @method        static Carbon  __set_state(array $array)                                                             https://php.net/manual/en/datetime.set-state.php
 *
 * </autodoc>
 */
class Carbon extends DateTime implements CarbonInterface
{
    use Date;

    /**
     * Returns true if the current class/instance is mutable.
     *
     * @return bool
     */
    public static function isMutable()
    {
        return true;
    }
}
