<?php
	
	use \Vinteract\Client;
	use \Vinteract\Features;
	use \Vinteract\Payments\Payments;

	class Account extends MY_Controller {
		
		public function __construct() {
			parent::__construct();
		}
		
		public function _remap($method, $args) {
			if ($this->get) {
				
				(new \Vinteract\API\Response([
					"code" => 200,
					"contents" => [
						"client" => [
							"id" => Client::getData("public_id"),
							"name" => Client::getDisplayName(),
							"timezone" => Client::getData("timezone"),
							"website" => Client::getWebsiteURL(),
							"payments_subdomain" => Client::getData("payments_subdomain"),
							"account_holder" => Client::getAccountHolder(),
							"features" => [
								"payments" => Features::isFeatureEnabled("vinteract_pay"),
								"payments_hosted_page" => Features::isFeatureEnabled("vinteract_pay_hosted_page"),
								"payments_integrations" => Features::isFeatureEnabled("vinteract_pay_integrations"),
								"payments_campuses" => Features::isFeatureEnabled("vinteract_pay_campuses"),
							],
							"platforms" => Client::getPlatforms(),
						],
						"payments" => [
							"account" => Payments::getAccountDetails([
								"information" => [
									"legal_entity_name",
									"legal_entity_number",
									"legal_entity_type",
									"trading_name",
									"registration_date",
									"type_of_trust",
									"association_incorporation_number",
									"country_trust_was_established_in",
									"settlor_of_the_trust",
									"address_1",
									"address_2",
									"acnc_registered",
									"dgr_registered",
									"cc_settlement_account_name",
									"cc_settlement_account_number",
									"cc_settlement_bsb_number",
									"business_summary",
									"number_of_transactions_per_month",
									"average_sale_amount",
									"total_annual_turnover",
									"average_days_to_deliver",
									"platform_fee_percentage",
									"platform_fee_fixed",
									"account_holder_name",
									"account_holder_email_address",
									"account_holder_phone_number",
								],
								"settings" => [
									"logo_url",
									"brand_colour",
									"default_currency",
									"terms_and_conditions",
									"terms_and_conditions_approved_by",
									"terms_and_conditions_approved_on",
									"merchant_agreement_approved_by",
									"merchant_agreement_approved_on",
									"account_approved_by",
									"account_approved_by_position",
									"account_approved_on",
									"disable_payment_form",
									"disable_payment_form_message",
									"hosted_page_brand_icon",
									"hosted_page_brand_name",
									"hosted_page_title",
									"hosted_page_description",
									"hosted_page_banner_image",
									"receipt_bcc_recipients",
								]
							]),
							"provider" => Payments::getProviderDetails(),
							"platform" => Payments::getPlatformDetails(),
						],
					]
				]))->echoResponse();
				
			} else if ($this->post) {
				
				if ($method === "activate") {
					
					// Variables.
					
					$client_id = Client::getPublicId();
					$client_signature_path = "./uploads/clients/{$client_id}/signatures";
					
					$signatory = $this->input->post("signatory");
					
					$date = new DateTime();
					
					// Activate their account.
					
					if (ENVIRONMENT === "production") {
						$activated = Client::local("vpay_account")->updateOrInsert(["key" => "status"], [ "value" => "pending" ]);
					} else {
						$activated = Client::local("vpay_account")->updateOrInsert(["key" => "status"], [ "value" => "active" ]);
					}
					
					// Success or not?
					
					if ($activated) {
						
						// Store the user's name and the date and time they approved the agreement(s).
						
						Client::local("vpay_settings")->updateOrInsert(["key" => "account_approved_by"], [ "value" => $signatory["name"] ]);
						Client::local("vpay_settings")->updateOrInsert(["key" => "account_approved_by_position"], [ "value" => $signatory["position"] ]);
						Client::local("vpay_settings")->updateOrInsert(["key" => "account_approved_on"], [ "value" => $date->format("j F, Y") ]);
						
						// Store the user's signature.
						
						if (!is_dir($client_signature_path)) {
							mkdir($client_signature_path, 0777, true);
							file_put_contents("{$client_signature_path}/index.html", "");
						}
						
						file_put_contents("{$client_signature_path}/account.png", \Vinteract\Utils::extractBase64ImageData($this->input->post("signature")));
						
						// Create the account holder email address.
						
						if (!Client::local("vpay_account")->where("key", "account_holder_email_address")->exists()) {
							Client::local("vpay_account")->insert([ "key" => "account_holder_email_address", "value" => Payments::generateReddeOfficeEmailAddress(Client::getDisplayName()) ]);
						}
						
						// Send email notification to our production team.
						
						$emailClient = new \Vinteract\Notifications\Email();
						
						$emailTemplate = \Vinteract\Notifications\EmailTemplates::getTemplate("onboardingComplete", [
							"{FULL_NAME}" => $signatory["name"],
							"{CLIENT_NAME}" => Client::getDisplayName(),
							"{DATE}" => $date->format("j F, Y"),
							"{URL}" => Payments::getApplicationFormURL(),
						]);
						
						$emailResponse = $emailClient->send([
							"to" => [
								[ "name" => "Simon Berry", "email" => "simon@vertogroup.com.au" ],
								[ "name" => "Simon Burford", "email" => "simon.burford@vertogroup.com.au" ],
							],
							"subject" => $emailTemplate["subject"],
							"html" => $emailTemplate["html"],
						]);
						
						// Response.
						
						(new \Vinteract\API\Response([
							"code" => 200,
						]))->echoResponse();
						
					} else {
						
						// Response.
						
						(new \Vinteract\API\Response())->echoResponse();
						
					}
					
				} else {
					
					// Update account information?
					
					if ($this->input->post("account")) {
						
						// Variables.
						
						$account = $this->input->post("account");
						
						// Delete all personnel and trustees. This sounds bad but
						// because the client is submitting all new data it shouldn't
						// be a problem.
						
						\Vinteract\Payments\AccountPersonnel::query()->delete();
						
						\Vinteract\Payments\AccountTrusteePersonnel::query()->delete();
						
						\Vinteract\Payments\AccountTrustee::query()->delete();
						
						// Update account information.
						
						foreach ($account["information"] as $key => $value) {
							Client::local("vpay_account")->updateOrInsert(["key" => $key], ["key" => $key, "value" => $value]);
						}
						
						// Update personnel.
						
						foreach ($account["personnel"] as &$personData) {
							
							$dob = new DateTime($personData["date_of_birth"]);
							
							$personData["date_of_birth"] = $dob->format("Y-m-d");
							
							\Vinteract\Payments\AccountPersonnel::create($personData);
							
						}
						
						// Update trustees.
						
						foreach ($account["trustees"] as $trusteeData) {
							
							$trustee = \Vinteract\Payments\AccountTrustee::create($trusteeData);
							
							if (array_key_exists("personnel", $trusteeData)) {
								
								foreach ($trusteeData["personnel"] as &$personData) {
									
									$dob = new DateTime($personData["date_of_birth"]);
									
									$personData["trustee_id"] = $trustee->id;
									$personData["date_of_birth"] = $dob->format("Y-m-d");
									
									\Vinteract\Payments\AccountTrusteePersonnel::create($personData);
									
								}
								
							}
							
						}
						
					}
					
					// Update financial information?
					
					if ($this->input->post("financial")) {
						foreach ($this->input->post("financial") as $key => $value) {
							Client::local("vpay_account")->updateOrInsert(["key" => $key], ["key" => $key, "value" => $value]);
						}
					}
					
					// Response.
					
					(new \Vinteract\API\Response([
						"code" => 200,
					]))->echoResponse();
					
				}
				
			}
			
		}
		
	}
	
?>
