<?php
	
	use \Vinteract\Client;
	use \Vinteract\Features;
	use \Vinteract\Payments\Payments;
	
	class Application_Form extends MY_Controller {
		
		public function __construct() {
			parent::__construct();
		}
		
		public function account() {
			
			(new \Vinteract\API\Response([
				"code" => 200,
				"contents" => [
					"client" => [
						"id" => Client::getData("public_id"),
						"name" => Client::getDisplayName(),
						"timezone" => Client::getData("timezone"),
						"website" => Client::getWebsiteURL(),
						"payments_subdomain" => Client::getData("payments_subdomain"),
						"account_holder" => Client::getAccountHolder(),
						"features" => [
							"payments" => Features::isFeatureEnabled("vinteract_pay"),
							"payments_hosted_page" => Features::isFeatureEnabled("vinteract_pay_hosted_page"),
							"payments_integrations" => Features::isFeatureEnabled("vinteract_pay_integrations"),
							"payments_campuses" => Features::isFeatureEnabled("vinteract_pay_campuses"),
						],
						"platforms" => Client::getPlatforms(),
					],
					"payments" => [
						"account" => Payments::getAccountDetails([
							"information" => [
								"legal_entity_name",
								"legal_entity_number",
								"legal_entity_type",
								"trading_name",
								"registration_date",
								"type_of_trust",
								"association_incorporation_number",
								"country_trust_was_established_in",
								"settlor_of_the_trust",
								"address_1",
								"address_2",
								"acnc_registered",
								"dgr_registered",
								"cc_settlement_account_name",
								"cc_settlement_account_number",
								"cc_settlement_bsb_number",
								"business_summary",
								"number_of_transactions_per_month",
								"average_sale_amount",
								"total_annual_turnover",
								"average_days_to_deliver",
								"platform_fee_percentage",
								"platform_fee_fixed",
								"account_holder_name",
								"account_holder_email_address",
								"account_holder_phone_number",
							],
							"settings" => [
								"logo_url",
								"brand_colour",
								"default_currency",
								"terms_and_conditions",
								"terms_and_conditions_approved_by",
								"terms_and_conditions_approved_on",
								"merchant_agreement_approved_by",
								"merchant_agreement_approved_on",
								"account_approved_by",
								"account_approved_by_position",
								"account_approved_on",
								"disable_payment_form",
								"disable_payment_form_message",
								"hosted_page_brand_icon",
								"hosted_page_brand_name",
								"hosted_page_title",
								"hosted_page_description",
								"hosted_page_banner_image",
								"internal_comments",
							]
						]),
						"provider" => Payments::getProviderDetails(),
						"platform" => Payments::getPlatformDetails(),
					],
				]
			]))->echoResponse();
			
		}
		
		public function save() {
			
			Client::local("vpay_settings")->updateOrInsert(["key" => "internal_comments"], [ "value" => $this->input->post("internal_comments") ]);
			
			(new \Vinteract\API\Response(["code" => 200]))->echoResponse();
			
		}
		
		public function auth() {
			
			$password = $this->input->post("password");
			
			$vertoGroupPassword = \Vinteract\Client::global("settings")->where("key", "vpay_application_form_verto_group_password")->value("value");
			$pinPaymentsPassword = \Vinteract\Client::global("settings")->where("key", "vpay_application_form_pin_payments_password")->value("value");
			
			if (($password === $vertoGroupPassword) or ($password === $pinPaymentsPassword)) {
				(new \Vinteract\API\Response([
					"code" => 200,
					"contents" => [
						"admin" => ($password === $vertoGroupPassword),
					]
				]))->echoResponse();
			} else {
				(new \Vinteract\API\Response(["code" => 401]))->echoResponse();
			}
			
		}
		
	}
	
?>
