<?php
	
	class BSB extends MY_Controller {
		
		private $bank_codes = '{"ANZ":{"name":"Australia and New Zealand Banking Group"},"WBC":{"name":"Westpac Banking Corporation"},"CBA":{"name":"Commonwealth Bank of Australia"},"NAB":{"name":"National Australia Bank"},"RBA":{"name":"Reserve Bank of Australia"},"BSA":{"name":"BankSA (division of Westpac Bank)"},"STG":{"name":"St George Bank (division of Westpac Bank)"},"SGP":{"name":"St George Bank (division of Westpac Bank)"},"BQL":{"name":"Bank of Queensland"},"PIB":{"name":"Rabobank"},"T&C":{"name":"Town & Country Bank"},"MBL":{"name":"Macquarie Bank"},"BOM":{"name":"Bank of Melbourne (division of Westpac Bank)"},"BML":{"name":"Bank of Melbourne (division of Westpac Bank)"},"CMB":{"name":"JP Morgan Chase Bank"},"BNP":{"name":"BNP Paribas"},"BAL":{"name":"Bank of America"},"CTI":{"name":"Citibank & Citibank NA"},"CAN":{"name":"Citibank & Citibank NA"},"BPS":{"name":"BNP Paribas Securities"},"BTA":{"name":"Bankers Trust Australia (division of Westpac Bank)"},"BOT":{"name":"MUFG Bank"},"BWA":{"name":"Bankwest (division of Commonwealth Bank)"},"MCU":{"name":"Bank Australia"},"BYB":{"name":"Beyond Bank"},"HBA":{"name":"HSBC Bank Australia"},"HSB":{"name":"HSBC Bank Australia"},"BOC":{"name":"Bank of China"},"BCA":{"name":"Bank of China"},"CST":{"name":"Commonwealth Bank of Australia"},"DBA":{"name":"Deutsche Bank"},"TBT":{"name":"Commonwealth Bank of Australia"},"OCB":{"name":"OCBC Bank"},"ADV":{"name":"Advance Bank (division of Westpac Bank)"},"CBL":{"name":"Challenge Bank (division of Westpac Bank)"},"MET":{"name":"Suncorp-Metway"},"SUN":{"name":"Suncorp-Metway"},"CFC":{"name":"Community First Credit Union"},"QTM":{"name":"RACQ Bank"},"VOL":{"name":"Volt Bank"},"BCC":{"name":"Bananacoast Community Credit Union"},"ASL":{"name":"Australian Settlements"},"ADL":{"name":"Adelaide Bank (division of Bendigo and Adelaide Bank)"},"SEL":{"name":"Endeavour Mutual Bank"},"ABS":{"name":"Greater Bank"},"GBS":{"name":"Greater Bank"},"BAE":{"name":"B&E"},"BBL":{"name":"Bendigo Bank"},"UFS":{"name":"Uniting Financial Services"},"HBS":{"name":"Heritage Bank"},"HOM":{"name":"Home Building Society (division of Bank of Queensland)"},"HUM":{"name":"Hume Bank"},"IMG":{"name":"IMB"},"AUB":{"name":"IMB"},"ADC":{"name":"Australian Military Bank"},"MPB":{"name":"Auswide Bank"},"BAY":{"name":"Auswide Bank"},"MMB":{"name":"Maitland Mutual Building Society"},"NEW":{"name":"Newcastle Permanent Building Society"},"PPB":{"name":"Pioneer Permanent Building Society (division of Bank of Queensland)"},"ECU":{"name":"Queensland Country Credit Union"},"ROK":{"name":"The Rock"},"GCB":{"name":"G&C Mutual Bank"},"GTW":{"name":"Gateway Bank"},"CUS":{"name":"Indue"},"HCC":{"name":"Holiday Coast Credit Union"},"SNX":{"name":"Southern Cross Credit Union"},"HIC":{"name":"Bank of Heritage Isle"},"RCU":{"name":"MOVE"},"SCU":{"name":"Summerland Credit Union"},"PNB":{"name":"Police & Nurse"},"CRU":{"name":"Cuscal"},"YOU":{"name":"Cuscal"},"TMB":{"name":"Teachers Mutual Bank"},"CAP":{"name":"Capricornian"},"CUA":{"name":"Credit Union Australia"},"PCU":{"name":"Police Bank"},"WCU":{"name":"Warwick Credit Union"},"COM":{"name":"Bank of Communications"},"IBK":{"name":"Industrial & Commercial Bank of China"},"STH":{"name":"Sutherland Credit Union"},"SKY":{"name":"Big Sky Building Society"},"DBL":{"name":"Defence Bank"},"MMP":{"name":"Unity Bank"},"CCB":{"name":"China Construction Bank"},"APO":{"name":"Australia Post"},"SMB":{"name":"Sumitomo Mitsui Banking Corporation"},"SSB":{"name":"State Street Bank & Trust Company"},"ARA":{"name":"Arab Bank Australia"},"MCB":{"name":"Mizuho Bank"},"UOB":{"name":"United Overseas Bank"},"ING":{"name":"ING Bank"},"GNI":{"name":"ING Bank"},"ICB":{"name":"Mega International Commercial Bank"},"RAB":{"name":"Regional Australia Bank"},"AMP":{"name":"AMP Bank"},"BCY":{"name":"Delphi Bank (division of Bendigo and Adelaide Bank)"},"LBA":{"name":"Bank of Sydney"},"TBB":{"name":"Taiwan Business Bank"},"MEB":{"name":"Members Equity Bank"},"UBS":{"name":"UBS AG"},"INV":{"name":"BOQ Specialist"},"MSL":{"name":"Tyro Payments"}}';
		
		public function __construct() {
			
			parent::__construct();
			
			$this->bank_codes = json_decode($this->bank_codes, true);
			
		}
		
		public function _remap($method, $args) {
			
			if ($this->resource_id) {
				
				$bsb_data = @file_get_contents("http://api.beliefmedia.com/bsb/{$this->resource_id}.json");
				
				if ($bsb_data) {
					
					try {
						
						$bsb_data = json_decode($bsb_data, true);
						
						if ($bsb_data["code"] === "200") {
							
							$inst_code = $bsb_data["data"]["instcode"];
							$bank_name = $inst_code;
							$bank_logo = "";
							
							if (array_key_exists($bank_name, $this->bank_codes)) {
								$bank_name = $this->bank_codes[$inst_code]["name"];
							}
							
							if (file_exists("./assets/logos/banks/{$inst_code}.png")) {
								$bank_logo = site_url("/assets/logos/banks/{$inst_code}.png");
							}
							
							if ($bsb_data["code"] == 200) {
								(new \Vinteract\API\Response([
									"code" => 200,
									"contents" => [
										"bank" => [
											"bsb" => $bsb_data["data"]["bsbnumber"],
											"name" => $bank_name,
											"logo" => $bank_logo,
											"branch" => $bsb_data["data"]["branchname"],
											"city" => $bsb_data["data"]["suburb"],
											"state" => $bsb_data["data"]["state"],
											"postcode" => $bsb_data["data"]["postcode"],
											"country" => "Australia"
										]
									],
								]))->echoResponse();
							}
							
						}
						
					} catch (\Exception $e) {
						
					}
					
				}
				
			}
			
			(new \Vinteract\API\Response([
				"code" => 404,
			]))->echoResponse();
			
		}
		
	}
	
?>