<?php
	
	use \Vinteract\DB;
	use \Vinteract\Client;
	use \Vinteract\Payments\Payments;
	
	class Cron extends CI_Controller {
		
		private $globalDb;
		
		public function __construct() {
			
			// Construct parent.
			
			parent::__construct();
			
			// Autoload composer packages.
			
			require("vendor/autoload.php");
			
		}
		
		private function checkTransactions($orgType = "churches") {
			
			$organisations = $this->globalDb->table("global_{$orgType}")->get();
			
			foreach($organisations as $organisation) {
				
				// Load client.
				
				Client::init($organisation->public_id);
				
				// Load payments.
				
				Payments::boot();
				
				// Get recurring transactions and check their status and process them accordingly.
				//
				// 1. Check if the scheduled transaction is a failed transaction.
				//    If it is, check if the "retry charge date" has passed and then try
				//    processing the transaction again.
				//
				// 2. If its not a failed transaction ie its a normal scheduled transaction
				//    check if its an upcoming transaction and notify the user, otherwise
				//    process the transaction.
				
				$transactions = \Vinteract\Payments\RecurringTransactionRecord::active()->get();
				
				foreach ($transactions as $scheduled) {
					
					if ($scheduled->isFailedTransaction()) {
						
						if ($scheduled->isReadyToRetryCharge()) {
							
							$response = $scheduled->charge();
							
							if ($response->success()) {
								$scheduled->moveChargeDatesForward();
							} else {
								$scheduled->cancel($response->getMessage());
							}
							
						}
						
					} else {
						
						if ($scheduled->isAlmostReadyToBeCharged()) {
							
							// This empty block seems kind of redundant... I feel like
							// the function above should only return a true/false value, and
							// not automatically send the email.
							
						} else {
							
							if ($scheduled->isReadyToBeCharged()) {
								
								$response = $scheduled->charge();
								
								if ($response->success()) {
									
									// Move the charge dates forward.
									
									$scheduled->moveChargeDatesForward();
									
								} else {
									
									// Variables.
									
									$cancel = false;
									
									// Determine if we retry or cancel the card.
									
									switch ($response->getError()) {
										case "expired_card":
										case "suspected_fraud":
											$cancel = true;
									}
									
									// Update the database record.
									
									if ($cancel) {
										$scheduled->cancel($response->getMessage());
									} else {
										$scheduled->fail($response->getMessage());
									}
									
								}
								
							}
							
						}
						
					}
					
				}
				
			}
			
		}
		
		public function transactions() {
			
			/*
				Load Database
			*/
			
			$db = new DB(Client::getDatabaseConnections());
			
			$this->globalDb = $db->capsule->getConnection("default");
			
			/*
				Churches
			*/
			
			$this->checkTransactions("churches");
			
			/*
				Businesses
			*/
			
			$this->checkTransactions("businesses");
			
		}
		
		public function index() {
			show_404();
		}
		
	}
	
?>
