<?php
	
	use \Vinteract\Payments\DonationCause as DonationCause;
	
	class Donation_Causes extends MY_Controller {
		
		public function __construct() {
			
			parent::__construct();
			
		}
		
		public function _remap($method, $args) {
			
			if ($this->verb == "GET") {
				
				// New query instance.
				
				$query = \Vinteract\Payments\DonationCause::query();
				
				// Filter by active or all?
				
				if ($this->input->get("status") === "all") {
					$query->where("active", 1)->orWhere("active", 0);
				} elseif ($this->input->get("status") === "inactive") {
					$query->where("active", 0);
				} else {
					$query->where("active", 1);
				}
				
				// Filter by ID?
				
				if ($this->resource_id) {
					$query->where("id", $this->resource_id)->orWhere("public_id", $this->resource_id);
				}
				
				// Get results.
				
				$results = $query->get();
				
				// Response.
				
				(new Vinteract\API\Response([
					"code" => count($results) ? 200 : 404,
					"results" => isset($results) ? $results : null,
				]))->echoResponse();
				
			} else if ($this->verb == "POST") {
				
				if ($this->resource_id) {
					
					// Update existing donation cause.
					
					$donationCause = Vinteract\Payments\DonationCause::find(\Vinteract\Payments\DonationCause::wherePublicId($this->resource_id)->value("id"));
					
					if ($this->input->post("title")) {
						$donationCause->title = $this->input->post("title");
					}
					
					if ($this->input->post("body")) {
						$donationCause->body = $this->input->post("body");
					}
					
					if ($this->input->post("amount")) {
						$donationCause->amount = $this->input->post("amount");
					}
					
					if ($this->input->post("minimum_amount")) {
						$donationCause->minimum_amount = $this->input->post("minimum_amount");
					}

					if ($this->input->post("notes_placeholder")) {
						$donationCause->notes_placeholder = $this->input->post("notes_placeholder");
					}

					if ($this->input->post("archived")) {
						$donationCause->archived = $this->input->post("archived");
					}
					
					if (isset($this->input->post()["pwyw"])) {
						$donationCause->pwyw = $this->input->post("pwyw");
					}

					if (isset($this->input->post()["is_gift"])) {
						$donationCause->is_gift = $this->input->post("is_gift");
					}

					if (isset($this->input->post()["includes_tax"])) {
						$donationCause->includes_tax = $this->input->post("includes_tax");
					}

					if (isset($this->input->post()["who_pays_fees"])) {
						$donationCause->who_pays_fees = $this->input->post("who_pays_fees");
					}

					if (isset($this->input->post()["active"])) {
						$donationCause->active = $this->input->post("active");
					}

					if (isset($this->input->post()["has_notes"])) {
						$donationCause->has_notes = $this->input->post("has_notes");
					}
															
					$updated = $donationCause->save();
					
					// Response.
					
					if ($updated) {
						(new Vinteract\API\Response(["code" => 200]))->echoResponse();
					}
					
					(new Vinteract\API\Response())->echoResponse();
					
				} else {
					
					// Create new donation cause.
					
					$created = Vinteract\Payments\DonationCause::create([
						"title" => $this->input->post("title"),
						"body" => $this->input->post("body"),
						"amount" => $this->input->post("amount"),
						"minimum_amount" => $this->input->post("minimum_amount"),
						"pwyw" => $this->input->post("pwyw"),
						"is_gift" => $this->input->post("is_gift"),
						"includes_tax" => $this->input->post("includes_tax"),
						"who_pays_fees" => $this->input->post("who_pays_fees"),
						"has_notes" => $this->input->post("has_notes"),
						"notes_placeholder" => $this->input->post("notes_placeholder"),
					]);
					
					// Response.
					
					if ($created) {
						(new Vinteract\API\Response(["code" => 201]))->echoResponse();
					}
					
					(new Vinteract\API\Response())->echoResponse();
					
				}
				
			} else if ($this->verb == "DELETE") {
				
				\Vinteract\Payments\DonationCause::destroy(\Vinteract\Payments\DonationCause::wherePublicId($this->resource_id)->value("id"));
				
			}
			
		}
		
	}
	
?>
