<?php
	
	require("vendor/autoload.php");
	
	use \Vinteract\Client;
	use \Vinteract\Payments\Payments;
	
	class Patch extends CI_Controller {
		
		public function __construct() {
			
			parent::__construct();
			
			if (!$this->input->is_cli_request()) {
				exit("Access denied.");
			}
			
			$this->globalDb = $this->load->database("global", true);
			
		}
		
		public function create_time_value_from_send_date() {
			
			/*
				Churches
			*/
			
			$churches = $this->globalDb->get("global_churches")->result();
			
			foreach ($churches as $church) {
				Client::init($church->public_id);
				$notifications = \Vinteract\Resources\QueuedNotification::all();
				foreach($notifications as $notification) {
					if (isset($notification->start_date)) {
						$startDate = new DateTime($notification["start_date"]);
						$startDate->setTimezone(new DateTimezone(Client::getTimezone()));
						$notification->time = $startDate->format("g:i A");
						$notification->save();
					}
				}
			}

			/*
				Businesses
			*/
			
			$businesses = $this->globalDb->get("global_businesses")->result();
			
			foreach ($businesses as $business) {
				Client::init($business->public_id);
				$notifications = \Vinteract\Resources\QueuedNotification::all();
				foreach($notifications as $notification) {
					if (isset($notification->start_date)) {
						$startDate = new DateTime($notification["start_date"]);
						$startDate->setTimezone(new DateTimezone(Client::getTimezone()));
						$notification->time = $startDate->format("g:i A");
						$notification->save();
					}
				}
			}
			
		}
		
		public function update_redde_clients_to_use_new_rates() {
			
			/*
				Churches
			*/
			
			$churches = $this->globalDb->get("global_churches")->result();
			
			foreach ($churches as $church) {
				Client::init($church->public_id);
				Client::local("vpay_account")->updateOrInsert(
					[ "key" => "platform_fee_percentage" ],
					[ "value" => "1.9" ]
				);
			}
			
			/*
				Businesses
			*/
			
			$businesses = $this->globalDb->get("global_businesses")->result();
			
			foreach ($businesses as $business) {
				Client::init($business->public_id);
				Client::local("vpay_account")->updateOrInsert(
					[ "key" => "platform_fee_percentage" ],
					[ "value" => "1.9" ]
				);
			}
			
		}
		
		public function fix_broken_terms_and_conditions_links() {
			
			/*
				Churches
			*/
			
			$churches = $this->globalDb->get("global_churches")->result();
			
			foreach ($churches as $church) {
				
				// Initialise client.
				
				Client::init($church->public_id);
				
				// Get terms and conditions text from the redde settings table.
				
				$termsAndConditionsText = Payments::getSetting("terms_and_conditions");
				
				// Update client website URL.
				
				$websiteDomain = Client::getData("website_domain");
				
				$websiteUrlOld = "{$websiteDomain}.vinteract.com.au";
				$websiteUrlNew = "www.{$websiteDomain}";
				
				$termsAndConditionsText = str_replace($websiteUrlOld, $websiteUrlNew, $termsAndConditionsText);
				
				// Update Verto privacy policy URL.
				
				$vertoPrivacyPolicyUrlOld = "www.vinteract.com.au/privacy_policy";
				$vertoPrivacyPolicyUrlNew = "https://vertogroup.com.au/privacy-policy/";
				
				$termsAndConditionsText = str_replace($vertoPrivacyPolicyUrlOld, $vertoPrivacyPolicyUrlNew, $termsAndConditionsText);
				
				// Save modified terms and conditions text.
				
				Client::local("vpay_settings")->updateOrInsert(
					[ "key" => "terms_and_conditions" ],
					[ "value" => $termsAndConditionsText ]
				);
				
			}

			/*
				Businesses
			*/
			
			$businesses = $this->globalDb->get("global_businesses")->result();
			
			foreach ($businesses as $business) {
				
				// Initialise client.
				
				Client::init($business->public_id);
				
				// Get terms and conditions text from the redde settings table.
				
				$termsAndConditionsText = Payments::getSetting("terms_and_conditions");
				
				// Update client website URL.
				
				$websiteDomain = Client::getData("website_domain");
				
				$websiteUrlOld = "{$websiteDomain}.vinteract.com.au";
				$websiteUrlNew = "www.{$websiteDomain}";
				
				$termsAndConditionsText = str_replace($websiteUrlOld, $websiteUrlNew, $termsAndConditionsText);
				
				// Update Verto privacy policy URL.
				
				$vertoPrivacyPolicyUrlOld = "www.vinteract.com.au/privacy_policy";
				$vertoPrivacyPolicyUrlNew = "https://vertogroup.com.au/privacy-policy/";
				
				$termsAndConditionsText = str_replace($vertoPrivacyPolicyUrlOld, $vertoPrivacyPolicyUrlNew, $termsAndConditionsText);
				
				// Save modified terms and conditions text.
				
				Client::local("vpay_settings")->updateOrInsert(
					[ "key" => "terms_and_conditions" ],
					[ "value" => $termsAndConditionsText ]
				);
				
			}
			
		}
		
		public function index() {
			

		}
		
	}
	
?>