<?php
	
	class Refunds extends MY_Controller {
		
		public function __construct() {
			
			parent::__construct();
			
		}
		
		public function _remap($method, $args) {
			
			if ($this->post) {
				
				// Variables.
				
				$transaction_amount = \Vinteract\Utils::formatMoney($this->input->post("original_amount"));
				
				$refund_amount = \Vinteract\Utils::formatMoney($this->input->post("amount"));
				
				$payload = [
					"transaction" => [
						"id" => \Vinteract\Payments\TransactionRecord::whereTransactionId($this->resource_id)->value("id"),
						"transaction_id" => $this->resource_id,
						"amount" => $transaction_amount,
						"currency" => "AUD",
					],
					"refund" => [
						"amount" => $refund_amount,
						"reason" => $this->input->post("reason"),
						"other" => $this->input->post("other_reason"),
						"authorised_by" => $this->input->post("authorised_by"),
					],
				];
				
				// Process refund request.
				
				$refund = new \Vinteract\Payments\Refund();
				
				$refundResponse = $refund->process($payload);
				
				// Was the refund successful?
				
				if ($refundResponse->success()) {
					
					// Variables.
					
					$reason = $payload["refund"]["reason"];
					
					if ($reason === "Other") {
						$reason = $payload["refund"]["other"];
					}
					
					// Create a record of the refund.
					
					$record = \Vinteract\Payments\RefundRecord::create([
						"transaction_id" => $payload["transaction"]["id"],
						"refund_id" => $refundResponse->getRefundId(),
						"receipt_number" => $refundResponse->getReceiptNumber(),
						"response_code" => $refundResponse->getResponseCode(),
						"status" => $refundResponse->getStatus(),
						"amount" => $refund_amount,
						"fee" => $refundResponse->getFee(),
						"currency" => \Vinteract\Payments\Payments::getCurrency(),
						"description" => $reason,
						"authorised_by" => $payload["refund"]["authorised_by"],
					]);
					
					// Response.
					
					(new Vinteract\API\Response([
						"code" => $refundResponse->getValue("code")
					]))->echoResponse();
					
				}

				error_log(print_r($refundResponse, true));
				
				(new Vinteract\API\Response([
					"code" => $refundResponse->getValue("code"),
					"message" => $refundResponse->getValue("message"),
				]))->echoResponse();
				
			}
			
		}
		
	}
	
?>