<?php
	
	use \Vinteract\Client;
	
	class Settings extends MY_Controller {
		
		public function __construct() {
			
			parent::__construct();
			
		}
		
		public function _remap($method, $args) {
			
			if ($this->get) {
				
				
				
			} else if ($this->post) {
				
				// Variables.
				
				$post = $this->input->post();
				
				$payload = [];
				
				// Payload.
				
				if (array_key_exists("terms_and_conditions", $post)) {
					$payload[] = [ "key" => "terms_and_conditions", "value" => $this->input->post("terms_and_conditions") ];
				}
				
				if (array_key_exists("logo_url", $post)) {
					$payload[] = [ "key" => "logo_url", "value" => $this->input->post("logo_url") ];
				}
				
				if (array_key_exists("brand_colour", $post)) {
					$payload[] = [ "key" => "brand_colour", "value" => $this->input->post("brand_colour") ];
				}
				
				if (array_key_exists("disable_payment_form", $post)) {
					$payload[] = [ "key" => "disable_payment_form", "value" => $this->input->post("disable_payment_form") ];
				}
				
				if (array_key_exists("disable_payment_form_message", $post)) {
					$payload[] = [ "key" => "disable_payment_form_message", "value" => $this->input->post("disable_payment_form_message") ];
				}
				
				if (array_key_exists("receipt_bcc_recipients", $post)) {
					$payload[] = [ "key" => "receipt_bcc_recipients", "value" => $this->input->post("receipt_bcc_recipients") ];
				}
				
				if (array_key_exists("hosted_page_brand_icon", $post)) {
					$payload[] = [ "key" => "hosted_page_brand_icon", "value" => $this->input->post("hosted_page_brand_icon") ];
				}
				
				if (array_key_exists("hosted_page_brand_name", $post)) {
					$payload[] = [ "key" => "hosted_page_brand_name", "value" => $this->input->post("hosted_page_brand_name") ];
				}
				
				if (array_key_exists("hosted_page_title", $post)) {
					$payload[] = [ "key" => "hosted_page_title", "value" => $this->input->post("hosted_page_title") ];
				}
				
				if (array_key_exists("hosted_page_description", $post)) {
					$payload[] = [ "key" => "hosted_page_description", "value" => $this->input->post("hosted_page_description") ];
				}
				
				if (array_key_exists("hosted_page_banner_image", $post)) {
					$payload[] = [ "key" => "hosted_page_banner_image", "value" => $this->input->post("hosted_page_banner_image") ];
				}

				// Update v interact pay settings.
				
				foreach($payload as $setting) {
					Client::local("vpay_settings")->updateOrInsert(["key" => $setting["key"]], $setting);
				}
				
				// Update payments subdomain?
				
				if (array_key_exists("payments_subdomain", $post)) {
					if (Client::findByKey("payments_subdomain", $post["payments_subdomain"])) {
						(new \Vinteract\API\Response(["message" => "That subdomain has already been taken. Please try again"]))->echoResponse();
					} else {
						Client::update(["payments_subdomain" => $post["payments_subdomain"]]);
					}
				}
				
				// Response.
				
				(new \Vinteract\API\Response(["code" => 200]))->echoResponse();
				
			}
			
		}
		
	}
	
?>
