<?php
	
	use \Vinteract\Client;
	use \Vinteract\Utils;
	use \Vinteract\Auth\JwtToken;
	use \Vinteract\Resources\User;
	
	use \ReallySimpleJWT\Token;
	
	class Transactions extends MY_Controller {
		
		public function __construct() {
			
			parent::__construct();
			
		}
		
		public function _remap($method, $args) {
			
			if ($this->get) {
				
				if ($this->resource_id) {
					$results = \Vinteract\Payments\TransactionRecord::fetch($this->resource_id, $this->input->get());
				} else {
					$results = \Vinteract\Payments\TransactionRecord::fetch(null, $this->input->get());
				}
				
				(new \Vinteract\API\Response([
					"code" => count($results) ? 200 : 404,
					"results" => isset($results) ? $results : null,
				]))->echoResponse();
				
			} else if ($this->post) {
				
				// Payload.
				
				$payload = $this->input->post();
				
				// Variables.
				
				$card_token_id = null;

				if (array_key_exists("token", $payload["customer"]) && !empty($payload['customer']['token'])) {
				    
					$result = \Vinteract\Payments\CardTokenRecord::where('token', $payload['customer']['token'])->value('id');
					
					if (!empty($result)) {
						$card_token_id = $result;
					}

				}
				
				$todays_date = new DateTime();
				
				$charge_card_now = true;
				
				$first_name = $payload["customer"]["first_name"];
				$last_name = $payload["customer"]["last_name"];
				
				$full_name = "{$first_name} {$last_name}";
				
				$email = $payload["customer"]["email"];
				
				$amount = $payload["transaction"]["amount"];
				$currency = $payload["transaction"]["currency"];
				$description = $payload["transaction"]["description"];
				$notes = $payload["transaction"]["notes"];
				
				$frequency = $payload["transaction"]["frequency"]["type"];
				$interval = ($frequency === "recurring" ? $payload["transaction"]["frequency"]["interval"] : null);
				
				$user_paid_fees = $payload["transaction"]["user_paid_fees"];
				
				$recurring_transaction = ($frequency === "recurring");
				$recurring_transaction_id = null;

				$user = null;
				
				// Mobile number?
				
				if (array_key_exists("mobile", $payload["customer"]) and isset($payload["customer"]["mobile"])) {
					$mobile = $payload["customer"]["mobile"];
				} else {
					$mobile = null;
				}
				
				// Augment the customer's information to include their ip address.
				
				$payload["customer"]["ip"] = $this->get_user_ip();
				
				// Are they logged into a user account?
				
				if ($this->input->get_request_header("Authorization")) {
					
					$token = Utils::extractBearerToken($this->input->get_request_header("Authorization"));
					
					if (Token::validate($token, Client::getJWTSecretKey())) {
						
						$user = User::whereUuid(JwtToken::getPayloadData($token, "data.user.uuid"))->first();

						// Store user id for transaction record.
						
						$payload["customer"]["user_id"] = $user->id;
						
						// Update mobile number.
						
						if (array_key_exists("mobile", $payload["customer"]) and isset($payload["customer"]["mobile"])) {
							$user->phone = $mobile;
						}
						
						// Update address details.
						
						$user->street_1 = $payload["customer"]["address"]["street_1"];
						$user->suburb = $payload["customer"]["address"]["city"];
						$user->region = $payload["customer"]["address"]["state"];
						$user->postcode = $payload["customer"]["address"]["postcode"];
						$user->country = $payload["customer"]["address"]["country"];
						
						// Store card details?
						
						if (array_key_exists("remember", $payload["card"]) and $payload["card"]["remember"] == true) {
							
							$cardToken = new \Vinteract\Payments\CardToken();
							
							$cardTokenResponse = $cardToken->process($payload);
							
							$card_token_id = $cardTokenResponse->getValue("card.id");
							
							// Remove the card token from the request payload and
							// add the saved customer token to the request payload.
							// 
							// This will be used to charge them instead of the tokenised card.
							
							unset($payload["card"]["token"]);
							
							$payload["customer"]["token"] = $cardTokenResponse->getValue("card.token");
							
						}
						
						// Save user.
						
						$user->save();
						
					}
					
				}
				
				// What type of payment is it?
				// Recurring or one time?
				
				if ($recurring_transaction) {

					error_log(var_export($user, true));

					if (empty($user)) {
				        
				        $response = [
							"code" => 422,
							"message" => 'Please Login to Process Recurring Transaction',
						];
						
				        (new \Vinteract\API\Response($response))->echoResponse();
				    }
					
					// Calculate the dates.
					
					$start_date = new DateTime($payload["transaction"]["frequency"]["startDate"]);
					
					// Determine if we should charge the card now, or later.
					
					$charge_card_now = ($todays_date->format("Y-m-d") === $start_date->format("Y-m-d"));
					
					// Create the recurring transaction record.
					// This can be done regardless of whether we charge the card now or not.
					
					$recurring = \Vinteract\Payments\RecurringTransactionRecord::create([
						// Transaction info.
						"card_token_id" => $card_token_id,
						"interval" => $interval,
						"amount" => $amount,
						"currency" => $currency,
						"description" => $description,
						"start_date" => $start_date->format("Y-m-d"),
						"user_paid_fees" => $user_paid_fees,
						// Customer info.
						"first_name" => $first_name,
						"last_name" => $last_name,
						"email" => $email,
						"phone" => $payload["customer"]["mobile"],
						"street_1" => array_key_exists("street_1", $payload["customer"]["address"]) ? $payload["customer"]["address"]["street_1"] : null,
						"city" => $payload["customer"]["address"]["city"],
						"state" => $payload["customer"]["address"]["state"],
						"postcode" => $payload["customer"]["address"]["postcode"],
						"country" => $payload["customer"]["address"]["country"],
						// Product info.
						"product_id" => $payload["product"]["id"],
						"user_id" => $user->id,
						// Metadata.
						"date" => $todays_date->format("Y-m-d H:i:s"),
						"notes" => $notes,
					]);
					
					// Update recurring transaction id.
					
					$recurring_transaction_id = $recurring->id;
					
					// Send email notification.
					
					$emailClient = new \Vinteract\Notifications\Email();
					
					$emailTemplate = \Vinteract\Notifications\EmailTemplates::getTemplate("recurringPaymentSetup", [
						"{FIRST_NAME}" => $first_name,
						"{INTERVAL}" => $interval,
						"{AMOUNT}" => $amount,
						"{CURRENCY}" => $currency,
						"{DESCRIPTION}" => $description,
						"{START_DATE}" => $start_date->format("j F Y"),
					]);
					
					$emailResponse = $emailClient->send([
						"to" => [ [ "name" => $full_name, "email" => $email ] ],
						"sender" => \Vinteract\Client::getDisplayName(),
						"subject" => $emailTemplate["subject"],
						"html" => $emailTemplate["html"],
					]);
					
					// Response object.
					
					$response = [
						"code" => 200,
					];
					
				}
				
				// Should we charge the card?
				// Only if its a one time payment, or if the recurring
				// transaction's "start date" is the same as today's date.
				
				if ($charge_card_now) {
					
					// What type of transaction are we processing?
					
					if ($recurring_transaction) {
						$transaction = new \Vinteract\Payments\RecurringTransaction();
					} else {
						$transaction = new \Vinteract\Payments\Transaction();
					}
					
					// Process the transaction.
					
					$transactionResponse = $transaction->process($payload);
					
					// Was the transaction successful?
					
					if ($transactionResponse->success()) {
						
						// Create a record of the transaction.
						
						$record = \Vinteract\Payments\TransactionRecord::create([
							// Transaction info.
							"transaction_id" => $transactionResponse->getTransactionId(),
							"receipt_number" => $transactionResponse->getReceiptNumber(),
							"response_code" => $transactionResponse->getResponseCode(),
							"status" => $transactionResponse->getStatus(),
							"frequency" => $frequency,
							"interval" => $interval,
							"amount" => $amount,
							"fee" => $transactionResponse->getFee(),
							"platform_fee" => \Vinteract\Payments\Payments::calculatePlatformFeeOnAmount($payload["transaction"]["amount"]),
							"currency" => $currency,
							"description" => $description,
							"user_paid_fees" => $user_paid_fees,
							// Customer info.
							"first_name" => $first_name,
							"last_name" => $last_name,
							"email" => $email,
							"phone" => $mobile,
							"street_1" => array_key_exists("street_1", $payload["customer"]["address"]) ? $payload["customer"]["address"]["street_1"] : null,
							"city" => $payload["customer"]["address"]["city"],
							"state" => $payload["customer"]["address"]["state"],
							"postcode" => $payload["customer"]["address"]["postcode"],
							"country" => $payload["customer"]["address"]["country"],
							"user_id" => array_key_exists("user_id", $payload["customer"]) ? $payload["customer"]["user_id"] : null,
							// Product info.
							"is_gift" => $payload["product"]["is_gift"],
							"includes_tax" => $payload["product"]["includes_tax"],
							"product_id" => $payload["product"]["id"],
							// Recurring transaction info.
							"recurring_transaction_id" => $recurring_transaction_id,
							// Card info.
							"card_type" => $transactionResponse->getCardType(),
							"card_last_4" => $transactionResponse->getCardNumber(),
							// Metadata.
							"date" => $todays_date->format("Y-m-d H:i:s"),
							"notes" => $notes,
						]);
						
						// Get email template.
						
						$emailVariables = [ "{FIRST_NAME}" => $first_name, "{INTERVAL}" => $interval, "{AMOUNT}" => $amount, "{CURRENCY}" => $currency, "{DESCRIPTION}" => $description, "{URL}" => \Vinteract\Payments\Payments::getReceiptURL($record->receipt_number) ];
						
						if ($recurring_transaction) {
							$emailTemplate = \Vinteract\Notifications\EmailTemplates::getTemplate("successfulRecurringPayment", $emailVariables);
						} else {
							$emailTemplate = \Vinteract\Notifications\EmailTemplates::getTemplate("successfulPayment", $emailVariables);
						}
						
						// Email recipients.
						
						$cardholder = [ [ "name" => $full_name, "email" => $email ] ];
						
						$receiptBccRecipients = \Vinteract\Payments\Payments::getReceiptBccRecipients();

						$to = $cardholder;

						foreach ($receiptBccRecipients as $recipient) {
							if (!empty($recipient['email'])) {
								$to = array_merge($to, $receiptBccRecipients);
							}
						}

						// Send email notification.
						
						$emailClient = new \Vinteract\Notifications\Email();
						
						$emailResponse = $emailClient->send([
							"to" => $to,
							"sender" => \Vinteract\Client::getDisplayName(),
							"subject" => $emailTemplate["subject"],
							"html" => $emailTemplate["html"],
						]);
						
						// Response object.
						
						$response = [
							"code" => $transactionResponse->getValue("code"),
							"contents" => [
								"transaction" => $record,
							]
						];
						
					} else {
						
						$response = [
							"code" => $transactionResponse->getValue("code"),
							"message" => $transactionResponse->getValue("message"),
						];
						
					}
					
				}
				
				// Response.
				
				(new \Vinteract\API\Response($response))->echoResponse();
				
			}
			
		}
		
	}
	
?>
