<?php
	
	// You shall not pass!
	
	if (!defined("BASEPATH")) exit("No direct script access allowed");
	
	/**
	 * 
	 * Parent Class
	 * 
	 * @package		Vinteract
	 * @subpackage	Payments API
	 * @author		Simon Burford
	 * 
	 */
	
	header("Access-Control-Allow-Origin: *");
	header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
	header("Access-Control-Allow-Headers: Authorization, Vinteract-Access-Token, Content-Type");
	header("Access-Control-Expose-Headers: Authorization");
	
	class MY_Controller extends CI_Controller {
		
		public $verb;
		
		public $get;
		public $post;
		
		public $resource_type;
		public $resource_id;
		
		public function __construct() {
			
			// Construct parent.
			
			parent::__construct();

			// Error Reporting
	
        	error_reporting(E_ERROR | E_PARSE);
        	ini_set('display_errors', '0');
        	ini_set("log_errors", 1);
        	ini_set("error_log", __DIR__ . "/../error_log");
			
			// Autoload composer packages.
			
			require("vendor/autoload.php");
			
			// Properties.
			
			$this->verb = $_SERVER["REQUEST_METHOD"];
			
			$this->get = $this->verb === "GET";
			$this->post = $this->verb === "POST";
			$this->delete = $this->verb === "DELETE";
			$this->options = $this->verb === "OPTIONS";
			$this->resource_type = $this->uri->segment(1);
			$this->resource_id = $this->uri->segment(2);
			
			try {
				$_POST = json_decode(file_get_contents("php://input"), true);
				$_POST = $_POST[0];
			} catch (\Exception $e) {
				$_POST = [];
			}
			
			// If its a pre-flight options request cancel the request thus sending the above response headers.
			
			if ($this->options) {
				
				exit();
				
			} else {
				
				// Load the client's information from the access token in the request headers.
				
				$accessToken = (new \Vinteract\Payments\AccessToken())->load();
				
				// If the access token is valid load the client and boot the payments class.
				
				if ($accessToken->valid()) {
					
					\Vinteract\Client::init($accessToken->get("public_id"));
					
					\Vinteract\Payments\Payments::boot();
					
				} else {
					
					(new \Vinteract\API\Response([
						"code" => 401
					]))->echoResponse();
					
				}
				
			}
			
		}
		
		/*
			
			Other functions
			
		*/
		
		public function get_user_ip() {
			if (!empty($_SERVER["HTTP_CLIENT_IP"])) {
				$ip = $_SERVER["HTTP_CLIENT_IP"];
			} elseif (!empty($_SERVER["HTTP_X_FORWARDED_FOR"])) {
				$ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
			} else {
				$ip = $_SERVER["REMOTE_ADDR"];
			}
			return $ip;
		}
		
		/*public function random_string($length = 5) {
			$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
			$randomString = '';
			for ($i = 0; $i < $length; $i++) {
				$randomString .= $characters[rand(0, strlen($characters) - 1)];
			}
			return $randomString;
		}
		
		public function __response($params = null, $echo = false) {
			
			// No params?
			
			if ($params == null) {
				$params = array();
			}
			
			// Variables.
			
			$code = array_key_exists("code", $params) ? $params["code"] : 400;
			$contents = array_key_exists("contents", $params) ? $params["contents"] : array();
			$message = array_key_exists("message", $params) ? $params["message"] : null;
			
			// Messages.
			
			$messages = array(
				200 => "Success.",
				201 => "Successfully created.",
				400 => "There is an issue with your request.",
				401 => "You are not authorized to make this request.",
				403 => "Forbidden request.",
				404 => "That resource could not be found.",
				500 => "Internal server error.",
			);
			
			// Response.
			
			$response = array(
				"code" => $code,
				"message" => $messages[$code],
			);
			
			// Custom response message?
			
			if ($message != null) {
				$response["message"] = $message;
			}
			
			// Success or error?
			
			if ($code == 200 or $code == 201) {
				$response["success"] = true;
			} else {
				$response["error"] = true;
			}
			
			// Custom contents.
			
			foreach($contents as $key => $var) {
				$response[$key] = $var;
			}
			
			// Echo or return response?
			
			if ($echo) {
				
				header("Content-Type: application/json");
				
				http_response_code($response["code"]);
				
				echo json_encode($response, JSON_NUMERIC_CHECK);
				
				exit();
				
			}
			
			return $response;
			
		}
		
		function __encrypt_file($file, $destination, $passphrase) {
			// Open the file and returns a file pointer resource. 
			$handle = fopen($file, "rb") or die("Could not open a file."); 
			// Returns the read string.
			$contents = fread($handle, filesize($file));
			// Close the opened file pointer.
			fclose($handle); 
			$iv = substr(md5("\x1B\x3C\x58".$passphrase, true), 0, 8);
			$key = substr(md5("\x2D\xFC\xD8".$passphrase, true) . md5("\x2D\xFC\xD9".$passphrase, true), 0, 24);
			$opts = array('iv'=>$iv, 'key'=>$key);
			$fp = fopen($destination, 'wb') or die("Could not open file for writing.");
			// Add the Mcrypt stream filter with Triple DES
			stream_filter_append($fp, 'mcrypt.tripledes', STREAM_FILTER_WRITE, $opts); 
			// Write content in the destination file.
			fwrite($fp, $contents) or die("Could not write to file."); 
			// Close the opened file pointer.
			fclose($fp); 
		}
		
		function decrypt_file($file, $passphrase) {
		    $iv = substr(md5("\x1B\x3C\x58".$passphrase, true), 0, 8);
		    $key = substr(md5("\x2D\xFC\xD8".$passphrase, true) .
		    md5("\x2D\xFC\xD9".$passphrase, true), 0, 24);
		    $opts = array('iv'=>$iv, 'key'=>$key);
		    $fp = fopen($file, 'rb');
		    stream_filter_append($fp, 'mdecrypt.tripledes', STREAM_FILTER_READ, $opts);
		    return $fp;
		}*/
		
		function __rrmdir($dir) {
			if (is_dir($dir)) {
				$objects = scandir($dir);
				foreach ($objects as $object) {
					if ($object != "." && $object != "..") {
						if (filetype($dir."/".$object) == "dir"){
							rrmdir($dir."/".$object);
						}else{ 
							unlink($dir."/".$object);
						}
					}
				}
				reset($objects);
				rmdir($dir);
			}
		}
		
	}

?>