<?php

namespace Vinteract\Payments;

use \Vinteract\Client;

use \Illuminate\Database\Eloquent\Model;

class AccountTrusteePersonnel extends Model {
	
	/*
		Properties
	*/
	
	public $timestamps = false;
	
	protected $visible = ["name", "role", "address", "date_of_birth", "identity_document_url"];
	
	protected $fillable = ["trustee_id", "name", "role", "address", "date_of_birth", "identity_document_url"];
	
	/*
		Overrides
	*/
	
	public function __construct($attributes = []) {
		
		parent::__construct($attributes);
		
		$this->setTable(Client::getName() . "_vpay_account_personnel");
		$this->setConnection(Client::getType());
		
	}
	
}
