<?php

namespace Vinteract\Payments;

use \Vinteract\Client;

use \Vinteract\Resources\User;

use \Illuminate\Database\Eloquent\Model;

class CardTokenRecord extends Model {
	
	/*
		Properties
	*/
	
	public $timestamps = false;
	
	protected $visible = [
		"token",
		"type",
		"last_4",
		"expiry_month",
		"expiry_year",
		"primary",
		"user"
	];
	
	protected $fillable = [
		"user_id",
		"token",
		"type",
		"last_4",
		"expiry_month",
		"expiry_year",
		"primary",
	];
	
	/*
		Overrides
	*/
	
	public function __construct($attributes = []) {
		
		parent::__construct($attributes);
		
		$this->setTable(Client::getName() . "_vpay_card_tokens");
		$this->setConnection(Client::getType());
		
	}
	
	protected static function boot() {
		
		parent::boot();
		
		static::setEventDispatcher(new \Illuminate\Events\Dispatcher());
		
		static::creating(function($model) {
			$model->provider = \Vinteract\Payments\Payments::getProviderName();
		});
		
	}
	
	/*
		Functions
	*/
	
	public static function fetch($id = null) {
		if (isset($id)) {
			return self::where("id", $id)->get();
		} else {
			return self::all();
		}
	}
	
	/*
		Relationships
	*/
	
	public function user() {
		return $this->belongsTo(User::class, "user_id", "id");
    }
	
}
