<?php

namespace Vinteract\Payments;

use \Vinteract\Client;

use \Illuminate\Database\Eloquent\Model;

class DonationCause extends Model {
	
	/*
		Properties
	*/
	
	public $timestamps = false;
	
	protected $fillable = ["type", "title", "body", "image_url", "amount", "minimum_amount", "pwyw", "is_gift", "includes_tax", "who_pays_fees", "active", "archived", "has_notes", "notes_placeholder"];
	protected $visible = ["id", "public_id", "title", "body", "amount", "minimum_amount", "pwyw", "is_gift", "includes_tax", "who_pays_fees", "active", "archived", "has_notes", "notes_placeholder"];
	
	/*
		Overrides
	*/
	
	public function __construct($attributes = []) {
		
		parent::__construct($attributes);
		
		$this->setTable(Client::getName() . "_products");
		$this->setConnection(Client::getType());
		
	}
	
	protected static function boot() {
		
		parent::boot();
		
		static::setEventDispatcher(new \Illuminate\Events\Dispatcher());
		
		static::creating(function($model) {
			$model->type = "donations";
			$model->public_id = \Vinteract\Utils::generatePublicId();
		});
		
	}
	
	public function newQuery($excludeDeleted = true) {
		return parent::newQuery($excludeDeleted = true)->orderBy("active", "desc");
	}

	/*
		Functions
	*/
	
	public function scopeInactive($query) {
		return $query->where(["active" => 0]);
	}
	
	public function scopeActive($query) {
		return $query->where(["active" => 1]);
	}
	
	public static function fetch($id = null) {
		if (isset($id)) {
			return self::where("id", "=", $id)
				->orWhere("public_id", $id)
				->get();
		} else {
			return self::all();
		}
	}
	
}
