<?php

namespace Vinteract\Payments\Providers\PinPayments\Transfers;

use Vinteract\Payments\Providers\PinPayments\Transfers\TransferLineItem;

use Vinteract\Payments\Interfaces\TransferInterface;

use Vinteract\Payments\RefundRecord;
use Vinteract\Payments\TransactionRecord;

class Transfer implements TransferInterface {
	
	public function __construct($properties = []) {
		foreach($properties as $key => $value) {
	  		$this->{$key} = $value;
	    }
	}
	
	public function getDate() {
		return $this->paid_at;
	}
	
	public function getStatus() {
		return $this->status;
	}
	
	public function getAmount() {
		return $this->amount / 100;
	}
	
	public function getDebits() {
		return $this->total_debits / 100;
	}
	
	public function getCredits() {
		return $this->total_credits / 100;
	}
	
	public function getDescription() {
		return $this->description;
	}
	
	public function getCurrency() {
		return $this->currency;
	}
	
	public function getLineItems() {
		
		$items = [];
		
		if (isset($this->items)) {
			
			/*$this->items[] = new TransferLineItem([
				"type" => "chargeback_fee",
				"amount" => -2500,
				"currency" => "AUD",
				"created_at" => "2019-10-22T02:18:12Z",
				"object" => "charge",
				"token" => "ch_jcFO5gQp7qnNU6tgpxvMYA"
			]);
			
			$this->items[] = new TransferLineItem([
				"type" => "chargeback_recovery",
				"amount" => -28500,
				"currency" => "AUD",
				"created_at" => "2019-10-22T02:18:12Z",
				"object" => "charge",
				"token" => "ch_jcFO5gQp7qnNU6tgpxvMYA"
			]);
			
			$this->items[] = new TransferLineItem([
				"type" => "chargeback_fee_reversal",
				"amount" => 2500,
				"currency" => "AUD",
				"created_at" => "2019-10-22T02:18:12Z",
				"object" => "charge",
				"token" => "ch_jcFO5gQp7qnNU6tgpxvMYA"
			]);
			
			$this->items[] = new TransferLineItem([
				"type" => "chargeback_recovery_reversal",
				"amount" => 0,
				"currency" => "AUD",
				"created_at" => "2019-10-22T02:18:12Z",
				"object" => "charge",
				"token" => "ch_jcFO5gQp7qnNU6tgpxvMYA"
			]);
			
			$this->items[] = new TransferLineItem([
				"type" => "charge_merchant_entitlement",
				"amount" => 7106,
				"currency" => "AUD",
				"created_at" => "2019-10-22T02:18:12Z",
				"object" => "charge",
				"token" => "ch_jcFO5gQp7qnNU6tgpxvMYA"
			]);
			
			$this->items[] = new TransferLineItem([
				"type" => "refund_withhold_funds_from_transfer",
				"amount" => -500,
				"currency" => "AUD",
				"created_at" => "2019-10-17T04:30:31Z",
				"object" => "refund",
				"token" => "rf_mLn9My4d9m2EaF2u-w6vDQ"
			]);*/
			
			foreach ($this->items as $item) {
				
				$originalType = $item->getType();
				$modifiedType = explode("_", $originalType);
				$capitalisedType = implode(" ", array_map(function($s) { return ucfirst($s); }, $modifiedType));
				
				$lineItem = [
					"type" => $capitalisedType,
					"date" => $item->getDate(),
					"amount" => $item->getAmount(),
					"currency" => $item->getCurrency(),
				];
				
				if ($item->getValue("object") === "charge") {
					$lineItem["transaction"] = TransactionRecord::whereTransactionId($item->getValue("token"))->first();
				} else if ($item->getValue("object") === "refund") {
					$lineItem["refund"] = RefundRecord::whereRefundId($item->getValue("token"))->first();
				}
				
				$items[] = $lineItem;
				
			}
			
		}
		
		return $items;
		
	}
	
	public function setLineItems($lineItems = []) {
		foreach($lineItems as $lineItem) {
			$this->items[] = new TransferLineItem($lineItem);
		}
	}
	
}
