<?php

namespace Vinteract\Payments;

use \Vinteract\Client;

use \Illuminate\Database\Eloquent\Model;

class RefundRecord extends Model {
	
	protected $fillable = [
		"transaction_id",
		"refund_id",
		"receipt_number",
		"response_code",
		"status",
		"amount",
		"fee",
		"currency",
		"description",
		"authorised_by",
	];

	protected $with = [
		"transaction"
	];
	
	public function __construct($attributes = []) {
		
		parent::__construct($attributes);
		
		$this->setTable(Client::getName() . "_vpay_refunds");
		$this->setConnection(Client::getType());
		
	}
	
	protected static function boot() {
		parent::boot();
		static::setEventDispatcher(new \Illuminate\Events\Dispatcher());
		static::creating(function($model) {
			$model->provider = \Vinteract\Payments\Payments::getProviderName();
		});
	}
	
	public function newQuery($excludeDeleted = true) {
		return parent::newQuery($excludeDeleted = true)
			->orderBy("id", "desc");
	}
	
	public static function fetch($id = null) {
		if (isset($id)) {
			return self::where("id", $id)->get();
		} else {
			return self::all();
		}
	}

	/*
		Relationships
	*/
	
	public function transaction() {
        return $this->belongsTo("\Vinteract\Payments\TransactionRecord", "transaction_id", "id");
    }
	
}
